/***************************************************************************
                     langset.h  -  properties for a language
                             -------------------                                         
    begin                : Thu Mar 11 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/



#ifndef langset_h
#define langset_h

#include <vector.h>
#include <qstring.h>
#include <std/bastring.h>

class LangSet
{
 public:

   LangSet () {}

   void addSet (QString shortId, QString longId, QString PixMapFile);
   void addSet (QString shortId, QString shortId2, QString longId, QString PixMapFile);

   unsigned int size () const { return langs.size(); }
   void erase (int idx);

   QString shortId (int index) const;
   QString shortId2 (int index) const;
   QString longId (int index) const;
   QString PixMapFile (int index) const;

   int indexShortId (QString shortId) const;
   int indexLongId (QString longId) const;
   int indexPixMapFile (QString PixMapFile) const;

   int setShortId (QString shortId, int index);
   int setShortId2 (QString shortId2, int index);
   int setLongId (QString longId, int index);
   int setPixMapFile (QString PixMapFile, int index);

   QString findShortId (const QString &longId)  const;
   QString findLongId  (const QString &shortId) const;

 private:

   struct LangDef {
     QString shortId,
             shortId2,
             longId,
             PixMapFile;
   };

   vector<LangDef> langs;
};


#endif