
/***************************************************************************
           kvd_csv.cpp  -  maintain a document in text format
                             -------------------                                         
    begin                : Sat Sep 06 11:00:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold
    email                : ewald@ewald-arnold.de

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "compat_2x.h"
#include <kapp.h>

#include "kvoctraindoc.h"
#include "resource.h"

#include <qtextstream.h>
#include <qmessagebox.h>

bool kvoctrainDoc::saveTypeNameCsv (QTextStream &os)
{
 return true;
}


bool kvoctrainDoc::loadTypeNameCsv (QTextStream &is)
{
 return true;
}


bool kvoctrainDoc::saveLessonCsv (QTextStream &os)
{
 return true;
}


bool kvoctrainDoc::loadLessonCsv (QTextStream &is)
{
 return true;
}


bool kvoctrainDoc::saveToCsv (QTextStream& os, QString title,
                              const QString separator, QStrList *lang_order)
{
  saveTypeNameCsv (os);
  saveLessonCsv (os);

  int ent_no = 0;
  int ent_percent = (int) vocabulary.size () / 100;
  float f_ent_percent = (int) vocabulary.size () / 100.0;
  emit progressChanged(this, 0);

  os << i18n("! Title:")  << separator << getTitle() << "\n";
  os << i18n("! Author:") << separator << getAuthor() << "\n";

  vector<kvoctrainExpr>::const_iterator first =  vocabulary.begin ();
  while (first != vocabulary.end ()) {

    ent_no++;
    if (ent_percent != 0 && (ent_no % ent_percent) == 0 )
      emit progressChanged(this, ent_no / f_ent_percent);

    QString s, exp;

    // same block in kva_clip.cpp::slotEditCode()

    if (lang_order && lang_order->count() != 0) {
      // now concat columns according to paste-order
      for (int i = 0; i < (int) lang_order->count() && i < numLangs(); i++) {
        int j;
        if ((j = findIdent(lang_order->at(i))) >= 0) {
          if (j == 0)
            s = (*first).getOriginal();
          else
            s = (*first).getTranslation(j);

          if (i != 0 )
            exp += separator;
          exp += s;
        }
      }
  
    }
    else {
      exp = (*first).getOriginal();
      for (int i = 1; i <= (*first).numTranslations(); i++) {
        exp += separator;
        exp += (*first).getTranslation(i);
      }
    }

    if (!exp.isEmpty())
      os << exp << "\n";

    first++;
  }

  setModified (false);
  return os.device()->status() == IO_Ok;
}


bool kvoctrainDoc::loadFromCsv (QTextStream& is,
                                const QString separator, QStrList *lang_order)
{

  langs.clear();
  vocabulary.clear();
  int lang_num = 0;
  loadTypeNameCsv (is);
  loadLessonCsv (is);

  int size = is.device()->size ();
  int ln = size / 20 / 100;  // assume each line about 20 chars
  float f_ent_percent = size / 100.0;
  emit progressChanged (this, 0);

  for (int l = 0; !is.eof(); l++) {
    QString s = is.readLine();

    ln--;
    if (ln <= 0) {
      ln = size / 20 / 100;  // assume each line about 20 chars
      emit progressChanged(this, is.device()->at() / f_ent_percent);
    }

    // same block in kva_clip.cpp::slotEditPaste()

    if (!s.stripWhiteSpace().isEmpty()) {
      if (lang_order && lang_order->count() != 0) {
        kvoctrainExpr bucket (s, separator);
        kvoctrainExpr expr;
        // now move columns according to paste-order
        for (int i = 0; i < (int) lang_order->count() && i < bucket.numTranslations()+1; i++) {
          lang_num = QMAX (lang_num, bucket.numTranslations()+1);
          if (i == 0)
            expr.setOriginal(bucket.getOriginal());
          else
            expr.setTranslation(i, bucket.getTranslation(i));
        }
        appendEntry (&expr);
      }
      else {
        kvoctrainExpr expr (s, separator);
        appendEntry (&expr);
      }
    }
  }

  if (lang_order && lang_order->count() != 0)
    for (int i = 0; i < (int) lang_order->count() && i < lang_num; i++) {
      langs.push_back(lang_order->at(i));
    }
  else
    langs.push_back("en");

  setModified (false);
  return is.device()->status() == IO_Ok;
}


void kvoctrainDoc::errorCsv (int line, const QString &text )
{
   unknown_elem = true;
   QApplication::setOverrideCursor( arrowCursor, true );
   QString s = QString(KVOCTRAIN_TITLE)+QString(i18n(": error in csv file"));
   QString msg = text;
   QMessageBox mb( s,
       msg,
       QMessageBox::Critical,
       QMessageBox::Abort | QMessageBox::Default,
       0,
       0);
   mb.exec();
   QApplication::restoreOverrideCursor();
}
