/***************************************************************************
                FromToEntryPage.h  -- edit properties from/to original
                             -------------------                                         
    begin                : Mon Jun 28 21:02:16 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef FromToEntryPage_included
#define FromToEntryPage_included

#include "FromToEntryPageData.h"
#include <time.h>
#include <qdatetime.h>
#include "kvoctraindoc.h"

class FromToEntryPage : public FromToEntryPageData
{
    Q_OBJECT

public:

    FromToEntryPage
    (
        QDialog    *dlgbook,
        bool        multi_sel,
        grade_t     _grade,
        time_t      _date,
        count_t     _qcount,
        count_t     _bcount,
        QString     faux,
        const char *label,
        QWidget* parent = NULL,
        const char* name = NULL
    );

    time_t  dateDirty   () const { return date_dirty; }
    grade_t gradeDirty  () const { return grade_dirty; }
    count_t qCountDirty () const { return qcount_dirty; }
    count_t bCountDirty () const { return bcount_dirty; }

    time_t  getDate   () const;
    grade_t getGrade  () const { return grade; }
    count_t getQCount () const { return qcount; }
    count_t getBCount () const { return bcount; }

    QString getFauxAmi () const { return fauxami; }

    virtual ~FromToEntryPage();

protected:
    void keyPressEvent( QKeyEvent * );

protected slots:
    virtual void initFocus() const;
    virtual void slotGradeSelected(int);
    virtual void slotQCount(EA_QTSTR);
    virtual void slotBCount(EA_QTSTR);
    virtual void slotIncDay();
    virtual void slotDecYear();
    virtual void slotDecMonth();
    virtual void slotDecDay();
    virtual void slotIncYear();
    virtual void slotIncMonth();
    virtual void slotToday();
    virtual void slotNever();
    virtual void slotFauxAmiSelected(EA_QTSTR);

protected:
    void validate();

    QString   fauxami;
    bool       valid_date;
    bool       date_dirty,
               qcount_dirty,
               bcount_dirty,
               grade_dirty;
    grade_t    grade;
    count_t    qcount;
    count_t    bcount;
    int        year,
               month,
               day;
    QDialog   *dlgbook;
};

#endif // FromToEntryPage_included
