/***************************************************************************
                FromToEntryPage.cpp  -- edit properties from/to original
                             -------------------                                         
    begin                : Mon Jun 28 21:02:16 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "FromToEntryPage.h"

#define Inherited FromToEntryPageData

#include <qvalidator.h>
#include <qkeycode.h>

#include <kapp.h>

#include "kvoctraindoc.h"
#include "QueryManager.h"


class BlockAllValidator : public QValidator
{
 public:

  BlockAllValidator ()
    : QValidator (0, 0) {}

#ifdef EA_QT2x
  State validate (QString&, int& ) const {
    return Invalid; }
#else
  State validate (QString&, int& ) {
    return Invalid; }
#endif
};


static QStrList monthnames;

FromToEntryPage::FromToEntryPage
(
        QDialog    *_dlgbook,
        bool        multi_sel,
        grade_t     _grade,
        time_t      _time,
        count_t     _qcount,
        count_t     _bcount,
        QString     faux,
        const char *label,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name ),
        dlgbook(_dlgbook),
        fauxami(faux)
{
        grade = _grade;
        qcount = _qcount;
        bcount = _bcount;

        monthnames.clear();
        monthnames.append ("");
        monthnames.append (i18n("January"));
        monthnames.append (i18n("February"));
        monthnames.append (i18n("March"));
        monthnames.append (i18n("April"));
        monthnames.append (i18n("May"));
        monthnames.append (i18n("June"));
        monthnames.append (i18n("July"));
        monthnames.append (i18n("August"));
        monthnames.append (i18n("September"));
        monthnames.append (i18n("October"));
        monthnames.append (i18n("November"));
        monthnames.append (i18n("December"));

	fauxami_line->setText(fauxami);
        fauxami_label->setBuddy(fauxami_line);

        valid_date = false;
        QDateTime dt;
        QDate date;
        if (_time != 0 && !multi_sel) {
          dt.setTime_t (_time);
          valid_date = true;

          date = dt.date();
          year = date.year();
          month = date.month();
          day = date.day();
  
#ifndef EA_KDE2x
          QString s;
          s.setNum (day);
          day_spin->setValue(s);
          month_spin->setValue(monthnames.at(month));
          s.setNum (year);
          year_spin->setValue(s);
#else
          day_spin->setValue(day);
          month_spin->setValue(month);
          year_spin->setValue(year);
#endif
        }
        else {
          dt.setTime_t (time(0L));
          date = dt.date();
          year = date.year();
          month = date.month();
          day = date.day();
#ifndef EA_KDE2x
          year_spin->setValue("----");
          month_spin->setValue("----");
          day_spin->setValue("--");
#else
          year_spin->setValue(1);
          month_spin->setValue(1);
          day_spin->setValue(1);
#endif

          year_spin->setEnabled(false);
          month_spin->setEnabled(false);
          day_spin->setEnabled(false);
        }

        direc_label->setTitle (label);

        QString s;
        for (int i = 0; i <= KV_MAX_GRADE; i++) {
          s.setNum (i);
          gradebox->insertItem( QueryManager::gradeStr(i) );
        }
        gradebox->setCurrentItem (grade);
        grade_label->setBuddy (gradebox);

        s.setNum (qcount);
        qcount_line->setText (s);
        qcount_label->setBuddy (qcount_line);

        s.setNum (bcount);
        bcount_line->setText (s);
        bcount_label->setBuddy (bcount_line);

        gradebox->setValidator (new BlockAllValidator() );
        if (multi_sel) {
          fauxami_line->setEnabled(false);
          valid_date = false;
          bcount_line->setText ("");
          qcount_line->setText ("");
#ifndef EA_KDE2x
          year_spin->setValue("");
          month_spin->setValue("");
          day_spin->setValue("");
#else
          year_spin->setValue(1);
          month_spin->setValue(1);
          day_spin->setValue(1);
#endif
          // FIXME: possibly derive new combobox type
          //        which filters ALL charcters to prevent new input
          //        in edit field
          gradebox->clearEdit();
        }

        bcount_dirty = false;
        qcount_dirty = false;
        date_dirty = false;
        grade_dirty = false;
}


void FromToEntryPage::initFocus() const
{
  gradebox->setFocus();
}


FromToEntryPage::~FromToEntryPage()
{
}


void FromToEntryPage::slotFauxAmiSelected(EA_QTSTR s)
{
   fauxami = s;
}


void FromToEntryPage::slotGradeSelected (int g)
{
   grade_dirty = true;
   grade = g;
}


void FromToEntryPage::slotQCount(EA_QTSTR s)
{
   qcount_dirty = true;
   qcount = atoi (s);
}


void FromToEntryPage::slotBCount(EA_QTSTR s)
{
   bcount_dirty = true;
   bcount = atoi (s);
}


time_t FromToEntryPage::getDate   () const
{
// FIXME: warning dialog/don`t quit dialog when date invalid
   if (valid_date) {
     QDate act_date (year, month, day);
     QDateTime time_null (QDate (1970, 1, 1), QTime (0,0,0));
     return -QDateTime(act_date).secsTo (time_null);
   }
   else
     return 0;
}


void FromToEntryPage::validate()
{
  if (!valid_date) {
#ifndef EA_KDE2x
    QString s;
    s.setNum (day);
    day_spin->setValue(s);
    month_spin->setValue(monthnames.at(month));
    s.setNum (year);
    year_spin->setValue(s);
#else
    day_spin->setValue(day);
    month_spin->setValue(month);
    year_spin->setValue(year);
#endif
  }
  valid_date = true;
}


void FromToEntryPage::slotDecYear()
{
   date_dirty = true;
   year--;
   if (year < 1998)
     year = 1998;
#ifndef EA_KDE2x
   QString s;
   s.setNum (year);
   year_spin->setValue(s);
#else
   year_spin->setValue(year);
#endif
   validate();
}

// FIXME: dec month when day decrease below 1 ..

void FromToEntryPage::slotIncYear()
{
   date_dirty = true;
   year++;
   if (year > 2100)
     year = 2100;
#ifndef EA_KDE2x
   QString s;
   s.setNum (year);
   year_spin->setValue(s);
#else
   year_spin->setValue(year);
#endif
   validate();
}


void FromToEntryPage::slotDecMonth()
{
   date_dirty = true;
   month--;
   if (month < 1)
     month = 12;
#ifndef EA_KDE2x
   month_spin->setValue(monthnames.at(month));
#else
   month_spin->setValue(month);
#endif
   validate();
}


void FromToEntryPage::slotIncMonth()
{
   date_dirty = true;
   month++;
   if (month > 12)
     month = 1;
#ifndef EA_KDE2x
   month_spin->setValue(monthnames.at(month));
#else
   month_spin->setValue(month);
#endif
   validate();
}


void FromToEntryPage::slotDecDay()
{
   date_dirty = true;
   day--;
   if (day < 1)
     day = 31;
#ifndef EA_KDE2x
   QString s;
   s.setNum (day);
   day_spin->setValue(s);
#else
   day_spin->setValue(day);
#endif
   validate();
}


void FromToEntryPage::slotIncDay()
{
   date_dirty = true;
   day++;
   if (day > 31)
     day = 1;
#ifndef EA_KDE2x
   QString s;
   s.setNum (day);
   day_spin->setValue(s);
#else
   day_spin->setValue(day);
#endif
   validate();
}


void FromToEntryPage::slotToday()
{
   date_dirty = true;
   QDateTime dt;
   dt.setTime_t (time(0L));

   year_spin->setEnabled(false);
   month_spin->setEnabled(false);
   day_spin->setEnabled(false);

   year = dt.date().year();
   month = dt.date().month();
   day = dt.date().day();

#ifndef EA_KDE2x
   QString s;
   s.setNum (day);
   day_spin->setValue(s);
   month_spin->setValue(monthnames.at(month));
   s.setNum (year);
   year_spin->setValue(s);
#else
   day_spin->setValue(day);
   month_spin->setValue(month);
   year_spin->setValue(year);
#endif
   validate();
}


void FromToEntryPage::slotNever()
{
   date_dirty = true;
   year = 0;
   month = 0;
   day = 0;
#ifndef EA_KDE2x
   year_spin->setValue("----");
   month_spin->setValue("----");
   day_spin->setValue("--");
#else
   year_spin->setValue(1);
   month_spin->setValue(1);
   day_spin->setValue(1);
#endif
   year_spin->setEnabled(false);
   month_spin->setEnabled(false);
   day_spin->setEnabled(false);
   valid_date = false;
}


void FromToEntryPage::keyPressEvent( QKeyEvent *e )
{
   if (e->state() & AltButton & ControlButton & ShiftButton == 0) {
     if (  e->key() == Key_Escape )
       emit reject();
     else if (  e->key() == Key_Enter
              ||e->key() == Key_Return)
       emit accept();
     else
       e->ignore();
   }
   else
     e->ignore();
}
