/***************************************************************************
                 TitlePage.cpp  -  enter document title and author
                             -------------------                                         
    begin                : Thu Mar 11 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "TitlePage.h"
#include "resource.h"

#include <kapp.h>

#include <qkeycode.h>

#define Inherited TitlePageData

TitlePage::TitlePage
(
        QString  _title,
        QString  _author,
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
        setCaption (QString(KVOCTRAIN_TITLE) +i18n(": Input title and author"));
        title = _title;
        author = _author;
        e_author->setText (author);
        label_author->setBuddy(e_author);
#ifdef EA_QT2x
	connect( e_author, SIGNAL(textChanged(const QString&)), SLOT(slotAuthorChanged(const QString&)) );
#else
	connect( e_author, SIGNAL(textChanged(const char*)), SLOT(slotAuthorChanged(const char*)) );
#endif
        e_title->setText (title);
   	e_title->setFocus();
	e_title->selectAll();
        label_title->setBuddy(e_title);
#ifdef EA_QT2x
	connect( e_title, SIGNAL(textChanged(const QString&)), SLOT(slotTitleChanged(const QString&)) );
#else
	connect( e_title, SIGNAL(textChanged(const char*)), SLOT(slotTitleChanged(const char*)) );
#endif
}


void TitlePage::initFocus() const
{
  e_title->setFocus();
}


TitlePage::~TitlePage()
{
}


void TitlePage::slotTitleChanged(EA_QTSTR s)
{
  title = s;
}


void TitlePage::slotAuthorChanged(EA_QTSTR s)
{
  author = s;
}


void TitlePage::keyPressEvent( QKeyEvent *e )
{
   if (e->state() & AltButton & ControlButton & ShiftButton == 0) {
     if (  e->key() == Key_Escape )
       emit reject();
     else if (  e->key() == Key_Enter
              ||e->key() == Key_Return)
       emit accept();
     else
       e->ignore();
   }
   else
     e->ignore();
}
