/***************************************************************************
               DocPropDlg.h  -  document properties dialog class
                             -------------------                                         
    begin                : Fri Sep 10 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef _DocDlg_TYPES
#define _DocDlg_TYPES i18n("T&ypes")
#endif

#ifndef _DocDlg_TITLE
#define _DocDlg_TITLE i18n("T&itle")
#endif

#ifndef _DocDlg_LESSONS
#define _DocDlg_LESSONS i18n("L&essons")
#endif

#ifndef _DocDlg_OPTIONS
#define _DocDlg_OPTIONS i18n("&Options" )
#endif

#ifdef __ONLY_TO_BE_SEEN_BY_XGETTEXT
  _DocDlg_TITLE
  _DocDlg_TYPES
  _DocDlg_LESSONS
  _DocDlg_OPTIONS
#else


#ifndef DocPropsDlg_included
#define DocPropsDlg_included

#include <qtabdialog.h>

#include "DocOptionsPage.h"
#include "LessOptPage.h"
#include "TypeOptPage.h"
#include "TitlePage.h"
#include "GrammerManager.h"

#include <vector.h>

class kvoctrainDoc;
class LangPropPage;
class LangSet;

class DocPropsDlg : public QTabDialog
{
    Q_OBJECT

public:

    DocPropsDlg
    (
        kvoctrainDoc    *doc,
        const char      *start_page,
        QComboBox       *lessons,
        QString          title,
        QString          author,
        vector<QString>  types,
        LangSet         *langset,
        QWidget         *parent = NULL,
        const char      *name = NULL
    );

    virtual ~DocPropsDlg();

    bool getSorting()  const { return docOptPage->getSorting(); }

    QString getTitle()  { return titleOptPage->getTitle(); }
    QString getAuthor() { return titleOptPage->getAuthor(); }

    Conjugation getConjugation(int idx) const;
    Article     getArticle(int idx) const;

    void getLesson (QComboBox *lessons, vector<int>& ret_index) const
      { lessOptPage->getLesson (lessons, ret_index); }

    void getTypeNames (vector<QString> &types, vector<int>& ret_index) const
      { typeOptPage->getTypeNames (types, ret_index); }

protected slots:

    void cancelButton();
    void okButton();

protected:

    TypeOptPage    *typeOptPage;
    LessOptPage    *lessOptPage;
    TitlePage      *titleOptPage;
    DocOptionsPage *docOptPage;
    vector<LangPropPage*> langPages;
};

#endif // DocPropsDlg_included

#endif // __ONLY_TO_BE_SEEN_BY_XGETTEXT
