/***************************************************************************
                      aboutdialog.cpp  - about dialog
                             -------------------                                         
    begin                : Thu Nov 8 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

/*   TAKEN FROM AND MODIFIED AS NEEDED:
 *
 *   khexedit - Versatile hex editor
 *   Copyright (C) 1999  Espen Sand, espensa@online.no
 */


#include <qclipboard.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qmessagebox.h>
#include <qmultilinedit.h> 

#include <kapp.h>
#include <klocale.h>
#include <kbuttonbox.h>
#include <kiconloader.h>
#include <htmlview.h>
#include "compat_2x.h"

#ifdef EA_KDE2x
#include <krun.h>
#include <kmessagebox.h>
#else
#include <kfm.h>
#endif

#include "aboutdialog.h"
#include "resource.h"

#define OUTER_SEP 6
#define INNER_SEP 6

//
// There should always already be an space of INNER_SEP above the 
// action buttons. 
//
// This choice gives equal amount of space above and below the 
// buttons.
//
#define ACTION_SPACE (OUTER_SEP - INNER_SEP)

CAboutDialog::CAboutDialog( QWidget *parent, const char *name )
  : QDialog( parent, name, false, WStyle_Customize|WStyle_DialogBorder ) 
{
  about_version = i18n("Version: %s %s, Feb. 19. 2000 (KDE %s)");

  setIcon (QPixmap (EA_KDEDATADIR("",  "kvoctrain/mini-kvoctrain.xpm" )));
  QVBoxLayout *topLayout = new QVBoxLayout( this, OUTER_SEP, INNER_SEP ); 
  if( topLayout == 0 ) { return; }

  QString captionText;
  captionText.sprintf( i18n("About %s"), PACKAGE );
  setCaption( captionText );

#ifdef EA_KDE2x
  QFont titleFont( KGlobal::generalFont() );
#else
  QFont titleFont = kapp->generalFont;
#endif
  titleFont.setBold( true );
  titleFont.setPointSize( 16 );

#ifdef EA_KDE2x
  QFont authorFont( KGlobal::generalFont() );
#else
  QFont authorFont = kapp->generalFont;
#endif
  authorFont.setBold( true );

  QString appName( i18n("KDE vocabulary trainer") );
  QLabel *title = new QLabel( appName.data(), this );
  title->setFont(titleFont);
  title->setFixedHeight( title->sizeHint().height() );
  title->setFixedWidth( title->sizeHint().width() );
  title->setAlignment(AlignCenter);
  topLayout->addWidget( title );

  topLayout->addSpacing( INNER_SEP );

  QHBoxLayout *hbox = new QHBoxLayout();
  if( hbox == 0 ) { return; }
  topLayout->addLayout( hbox );

  QLabel *pixmap = new QLabel( this );
#ifdef EA_KDE2x
  KIconLoader &loader = *KGlobal::iconLoader();
  pixmap->setPixmap( loader.loadIcon( locate( "data", "large/kvoctrain.xpm" )) );
#else
  KIconLoader &loader = *kapp->getIconLoader();
  pixmap->setPixmap( loader.loadIcon( "large/kvoctrain.xpm" ) );
#endif
  pixmap->setFixedHeight( pixmap->sizeHint().height() );
  pixmap->setMinimumWidth( pixmap->sizeHint().width() );
  hbox->addWidget( pixmap, 0, AlignCenter );
  
  QVBoxLayout *vbox = new QVBoxLayout();
  if( vbox == 0 ) { return; }
  hbox->addLayout( vbox );

  QString versionString;
  versionString.sprintf( about_version, PACKAGE, VERSION,
			 KDE_VERSION_STRING );
  
  QLabel *version = new QLabel( versionString, this );
  version->setFont(authorFont);
  version->setFixedHeight( version->sizeHint().height() );
  version->setMinimumWidth( version->sizeHint().width() );
  vbox->addWidget( version, 0, AlignLeft );

  QString authorString;
  authorString.sprintf( i18n(" 1999,2000 Ewald Arnold") );
  QLabel *author = new QLabel( authorString, this );
  author->setFont(authorFont);
  author->setFixedHeight( author->sizeHint().height() );
  author->setMinimumWidth( author->sizeHint().width() );
  vbox->addWidget( author, 0, AlignLeft );
  hbox->addStretch(10);

  topLayout->addSpacing( INNER_SEP );

  mTabControl = new KTabCtl( this );
  if( mTabControl == 0 ) { return; }
  topLayout->addWidget( mTabControl, 10 );

#ifdef EA_KDE2x
  KConfig *config = KApplication::kApplication()->config();
#else
  KConfig *config = kapp->getConfig();
#endif
  config->setGroup(CFG_GENERAL);
  bool first_time = config->readNumEntry(CFG_FIRST_TIME, 1);
  config->writeEntry(CFG_FIRST_TIME, (bool) 0);

  mPage[ page_welcome ] = 0;

/*
  if (first_time)
    mPage[ page_welcome ] = addPage( QString(i18n("&Welcome")) );
*/
  mPage[ page_general ] = addPage( QString(i18n("&General")) );
  mPage[ page_contributor ] = addPage( QString(i18n("&Contributors")) );
  mPage[ page_licence ] = addPage( QString(i18n("&Licence agreement")) );
/*
  if (!first_time)
    mPage[ page_welcome ] = addPage( QString(i18n("&Welcome")) );
*/
  topLayout->addSpacing( ACTION_SPACE );  
  KButtonBox *buttonBox = new KButtonBox( this, KButtonBox::HORIZONTAL, 0, 
					  INNER_SEP );
  buttonBox->addStretch();
  QPushButton *closeButton = buttonBox->addButton( i18n("&OK"), false );
  connect( closeButton, SIGNAL(clicked()),this,SLOT(reject()) );
  buttonBox->layout();
  buttonBox->setMinimumSize( buttonBox->sizeHint() );
  topLayout->addWidget( buttonBox );

//  createWelcomePage();
  createGeneralPage();
  createContributorPage();
  createLicencePage();

  //
  // Compute the size of the tab widget. This will ensure that
  // the dialog is positioned (almost) correct the first time
  //
  QSize s( 0,0 );
  for( uint i=0; i<page_MAX; i++)
  {
    if (mPage[i] != 0)
      s = s.expandedTo( mPage[i]->minimumSize() );
  }
  s.setHeight( s.height()+20 ); // Tabs (bad practice!)
  mTabControl->setMinimumSize( s );

  topLayout->activate();
  setGeometry( x(), y(), minimumSize().width(), minimumSize().height() );
  setMinimumSize( s );
}

CAboutDialog::~CAboutDialog( void )
{

}


QFrame *CAboutDialog::addPage( const QString &title )
{
  QFrame *page = new QFrame( mTabControl, title.data() );
  page->setFrameStyle( QFrame::NoFrame );
  page->setEnabled( false );
  page->hide();

  mTabControl->addTab( page, title.data() );
  return( page );
}


void CAboutDialog::createGeneralPage( void )
{
  QFrame *page = mPage[ page_general ];

  QVBoxLayout *topLayout = new QVBoxLayout( page, INNER_SEP, INNER_SEP ); 
  if( topLayout == 0 ) { return; }
  
  topLayout->addStretch(5);

  QHBoxLayout *hbox = new QHBoxLayout(0);
  if( hbox == 0 ) { return; }
  topLayout->addLayout( hbox );

  QVBoxLayout *vbox = new QVBoxLayout(0);
  if( hbox == 0 ) { return; }
  hbox->addStretch(5);
  hbox->addLayout(vbox);
  hbox->addStretch(5);

  static QString reasonToMailMe = i18n(""
    "This is a work in progress. If you\n\n"
    "1. have a suggestion for improvement\n"
    "2. have found a bug\n"
    "3. want to contribute with something\n"
    "   - a vocabulary\n"
    "   - a localisation to a new language\n"
    "   - a nicer icon\n"
    "   or something else\n"
    "4. just want to tell me how nice or useful kvoctrain is\n\n"
    "then feel free to send me a mail.\n");

  QLabel *label;
  label = new QLabel( reasonToMailMe, page ); 
  label->setFixedHeight( label->sizeHint().height() );
  label->setFixedWidth( label->sizeHint().width() );
  vbox->addWidget( label, 0, AlignLeft );

  QGridLayout *gbox = new QGridLayout( 3, 2, INNER_SEP );
  vbox->addLayout( gbox );

  label = new QLabel( i18n("Email:"), page ); 
  label->setFixedHeight( label->sizeHint().height() );
  label->setFixedWidth( label->sizeHint().width() );
  gbox->addWidget( label, 0, 0, AlignLeft );

  CURLLabel *email = new CURLLabel( page, "email" );
  email->setText("kvoctrain@ewald-arnold.de");
  email->setURL("mailto:kvoctrain@ewald-arnold.de");
  email->setFloat(true);
  email->setUnderline(true);
  email->setFixedHeight( label->sizeHint().height() );
  email->setFixedWidth( email->sizeHint().width() );
  connect(email, SIGNAL(leftClick(const QString &)), 
	  SLOT(urlClick(const QString &)));
  gbox->addWidget( email, 0, 1, AlignLeft );

  label = new QLabel( i18n("Kvoctrain homepage:"), page );
  label->setFixedHeight( label->sizeHint().height() );
  label->setFixedWidth( label->sizeHint().width() );
  gbox->addWidget( label, 1, 0, AlignLeft );

  CURLLabel *kv_homepage = new CURLLabel( page, "kv_homePage" );
  kv_homepage->setText("http://devel-home.kde.org/~kvoctrain/");
  kv_homepage->setURL("http://devel-home.kde.org/~kvoctrain/");
  kv_homepage->setFloat(true);
  kv_homepage->setUnderline(true);
  kv_homepage->setFixedHeight( label->sizeHint().height() );
  kv_homepage->setFixedWidth( kv_homepage->sizeHint().width() );
  connect(kv_homepage, SIGNAL(leftClick(const QString &)), 
	  SLOT(urlClick(const QString &)));
  gbox->addWidget( kv_homepage, 1, 1, AlignLeft );

  label = new QLabel( i18n("Authors homepage:"), page );
  label->setFixedHeight( label->sizeHint().height() );
  label->setFixedWidth( label->sizeHint().width() );
  gbox->addWidget( label, 2, 0, AlignLeft );

  CURLLabel *my_homepage = new CURLLabel( page, "my_homePage" );
  my_homepage->setText("http://www.ewald-arnold.de");
  my_homepage->setURL("http://www.ewald-arnold.de");
  my_homepage->setFloat(true);
  my_homepage->setUnderline(true);
  my_homepage->setFixedHeight( label->sizeHint().height() );
  my_homepage->setFixedWidth( my_homepage->sizeHint().width() );
  connect(my_homepage, SIGNAL(leftClick(const QString &)),
	  SLOT(urlClick(const QString &)));
  gbox->addWidget( my_homepage, 2, 1, AlignLeft );

  topLayout->addStretch(5);
  topLayout->activate();
}


void CAboutDialog::createContributorPage( void )
{
  QFrame *page = mPage[ page_contributor ];
  QVBoxLayout *topLayout = new QVBoxLayout( page, INNER_SEP, INNER_SEP ); 
  if( topLayout == 0 ) { return; }
  
  static QString contrbutorText = i18n("\n"
    "This program uses modified code and techniques from other KDE programs,\n"
    "specifically klpq, killustrator and khexedit.\n"
    "\n"
    "Credit goes to their authors and maintainers.\n"
    "\n");

  QMultiLineEdit *contrbutorTextArea = new QMultiLineEdit(page);
  contrbutorTextArea->setReadOnly(true);
  contrbutorTextArea->setText( contrbutorText.data() );

  //
  // Add 20 pixels to (hopefully) avoid the vertical scrollbar
  //
  contrbutorTextArea->setMinimumWidth(contrbutorTextArea->maxLineWidth()+20);
  topLayout->addWidget( contrbutorTextArea );
  topLayout->activate();
}


void CAboutDialog::createWelcomePage( void )
{
  QFrame *page = mPage[ page_welcome ];
  QVBoxLayout *topLayout = new QVBoxLayout( page, INNER_SEP, INNER_SEP ); 
  if( topLayout == 0 ) { return; }
  
  static QString welcomeText = i18n("<HTML><BODY>"
    "<H1>Welcome to kvoctrain</H1>"
    "specifically klpq, killustrator and khexedit.\n"
    "\n"
    "<UL>\n"
    " <LI>Read the handbook\n"
    "</UL>\n"
    "Credit goes to their authors and maintainers.\n"
    "</BODY></HTML>");

  KHTMLView *welcomeTextArea = new KHTMLView(page);
  welcomeTextArea->begin();
  welcomeTextArea->parse();
  welcomeTextArea->write(welcomeText);
  welcomeTextArea->end();

  //
  // Add 20 pixels to (hopefully) avoid the vertical scrollbar
  //
  topLayout->addWidget( welcomeTextArea );
  topLayout->activate();
}


void CAboutDialog::createLicencePage( void )
{
  QFrame *page = mPage[ page_licence ];
  QVBoxLayout *topLayout = new QVBoxLayout( page, INNER_SEP, INNER_SEP ); 
  if( topLayout == 0 ) { return; }

  static QString licenseText = i18n("\n"
    "This program is free software; you can redistribute it and/or modify\n"
    "it under the terms of the GNU General Public License as published by\n"
    "the Free Software Foundation; either version 2 of the License, or\n"
    "(at your option) any later version.\n"
    "\n"
    "This program is distributed in the hope that it will be useful,\n"
    "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
    "GNU General Public License for more details.\n"
    "\n"
    "You should have received a copy of the GNU General Public License\n"
    "along with this program; if not, write to the Free Software\n"
    "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.\n");


  QMultiLineEdit *licenseTextArea = new QMultiLineEdit(page);
  licenseTextArea->setReadOnly(true);
  licenseTextArea->setText( licenseText.data() );

  //
  // Add 20 pixels to (hopefully) avoid the vertical scrollbar
  //
  licenseTextArea->setMinimumWidth(licenseTextArea->maxLineWidth()+20);
  topLayout->addWidget( licenseTextArea );
  topLayout->activate();
}


void CAboutDialog::urlClick( const QString &url ) 
{

#ifdef EA_KDE2x

  QString application("kfmclient");
 
  QString exec = QString("%1 exec %2").arg(application).arg(url);
  QStringList list;
  if( KRun::run( exec, list ) == false )
  {
    QApplication::clipboard()->setText( url );

    static QString msg = i18n(""
      "Unable to execute request\n\n"
      "The url address has been transfered to the clipboard.\n"
      "You can paste it into the address field of your web browser.");
    KMessageBox::sorry( this, msg, i18n("Operation failed") );
  }

#else

  KFM kfm;
  if( kfm.isKFMRunning() == false )
  {
    QApplication::clipboard()->setText( url.data() );

    static QString msg = i18n(""
      "Unable to execute request: KFM is not running.\n\n"
      "The url has been written to the clipboard.\n"
      "You can paste it into your mail client or web browser.");
    
    QMessageBox::warning(
      this,
      i18n("Operation failed"),
      msg.data(),
      i18n("&OK"),
      "",
      "",
      0,0 );
  }
  else
  {
    kfm.openURL( url );
  }

#endif

}


CURLLabel::CURLLabel( QWidget *parent, const char *name )
  :KURLLabel( parent, name )
{
  installEventFilter( this );
}


CURLLabel::~CURLLabel( void )
{
}


bool CURLLabel::eventFilter( QObject *object, QEvent *e )
{
#ifdef EA_QT2x
  if( e->type() == QEvent::MouseButtonPress )
#else
  if( e->type() == Event_MouseButtonPress )
#endif
  {
    QMouseEvent &m = *(QMouseEvent*)e;
    if( m.button() == LeftButton )
    {
      emit leftClick( url() );
    }
  }

  return( false );
}
