/***************************************************************************
                          vokabellist.cpp  -  description
                             -------------------
    begin                : Tue Dec 7 1999
    copyright            : (C) 1999 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "vvokabellist.h"


/**  */
int VVokabelList::compareItems( GCI V1, GCI V2 )
{
  int Result;

  switch( SortKey )
  {
    case SortTerm:         Result = strcmp( ((VVokabel*)V1)->string(TermColumn).data(), 
                                            ((VVokabel*)V2)->string(TermColumn).data() );
                           break;
      
    case SortTranslation:  Result = strcmp( ((VVokabel*)V1)->string(TranslationColumn).data(), 
                                            ((VVokabel*)V2)->string(TranslationColumn).data() );
                           break;
      
    case SortTyp:          Result = int( ((VVokabel*)V1)->symbol() - ((VVokabel*)V2)->symbol() );
                           break;

    case SortLevel:        Result = int( ((VVokabel*)V1)->level() - ((VVokabel*)V2)->level() );
                           break;

    default:               Result = 0;
  }

  return Result;
}


/** returns textline for ouput in file */
QString VVokabelList::line( VVokabel* Vokabel ) const
{
	if( !Vokabel ) return 0;

	QString Line;
	Line =   Vokabel->string( TermColumn ) 		  	      + VokSeparator 
			  	 + Vokabel->string( TranslationColumn)      + VokSeparator 
					 + Vokabel->symbol()         						      + VokSeparator 
					 + Line.setNum( Vokabel->level() ) + VokSeparator 
					 + Vokabel->remark();
	
		return Line;
}




/** inserts new vocabel in list 
    data is seperated by tabs
    term translation remark knowledge */
VVokabel *VVokabelList::newVokabel ( QString Data = 0 )
{
  // create vocabel and append
	VVokabel* Vokabel = new VVokabel();
	append( Vokabel );
	
	// anything to fill in?
	if( Data )
	{
    int Length = Data.length();
		
    // get Term 
  	int Begin = 0;                       
  	int End = Data.find( VokSeparator );				
  	if( End == -1 ) End = Length;
  	
  	Vokabel->setString( TermColumn, Data.mid( Begin, End-Begin ) );
	
  	if( End < Length ) 
	  {
    	// get Expression 
    	Begin = End+1;                        
    	End = Data.find( VokSeparator, Begin );       
    	if( End == -1 ) End = Length;
    	
    	Vokabel->setString( TranslationColumn, Data.mid( Begin, End-Begin ) );
    	
    	if( End < Length ) 
    	{
        // get Remark
      	Begin = End+1;                       
      	End = Data.find( VokSeparator, Begin );
      	if( End == -1 ) End = Length;
      	
      	if( Begin < End )
        	Vokabel->setSymbol( Data.mid( Begin, End-Begin ).at(0) );
        else
          Vokabel->initSymbol();
      	
      	if( End < Length )
        {
        	// get Wissen
        	Begin = End+1;                        
        	End = Data.find( VokSeparator, Begin );
        	if( End == -1 ) End = Length;
        	
        	Vokabel->setLevel( Data.mid( Begin, End-Begin ).toUShort() );
        	
        	if( End < Length ) 
        	{
            // get Remark
          	Begin = End+1;                       
          	End = Data.find( VokSeparator, Begin );
          	if( End == -1 ) End = Length;
          	
          	Vokabel->setRemark( Data.mid( Begin, End-Begin ) );
      	
        	// anything left (on the right ;-) will be ignored... 
        	}
        }
      }
    }
  }
	
	return Vokabel;  
}

