/***************************************************************************
                          vtyp.h  -  description
                             -------------------
    begin                : Thu Mar 23 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VTYP_H
#define VTYP_H

#include <qstring.h>

/**
  *@author Friedrich W. H. Kossebau
  */

typedef char VTypSymbol;
  
class VTyp
{
  public:
    VTyp(): Symbol(' ') {}
    VTyp( VTypSymbol NewSymbol ) { Symbol = NewSymbol; }
    ~VTyp() {}
    
    void initSymbol() { Symbol = ' '; }
    QString symbolString() { char String[2] = {Symbol, '\0'}; return QString(&String[0]); }
    VTypSymbol symbol() { return Symbol; }
    void setSymbol( VTypSymbol NewSymbol ) { Symbol = NewSymbol; }

  private:
    VTypSymbol Symbol;
};
  

class VTypInfo : public VTyp
{
  public:
    VTypInfo( VTypSymbol NewSymbol, QString NewName, QString NewLocalName )
     : VTyp(NewSymbol), Name(NewName), LocalName(NewLocalName) {}
    VTypInfo() {}
    ~VTypInfo() {}
    
    QString &name () { return Name; }
    QString &localName () { return LocalName; }
    
  private:
    QString Name;
    QString LocalName;
};

#endif
