/***************************************************************************
                          dokvokview.cpp  -  description
                             -------------------
    begin                : Son Dez 19 13:14:00 CET 1999
    copyright            : (C) 1999 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qlistview.h>

// application specific includes
#include "vvoklist.h"
#include "../File/vlangfile.h"
#include "dokvokview.h"
#include "../dokvokdoc.h"
#include "../dokvok.h"

DokVokView::DokVokView(QWidget *parent, const char *name) 
  : QWidget(parent, name), 
    VokList( this ),
    TypInfoList(),
    EditingPalette( palette().normal(), palette().disabled(), palette().normal() )
  
{
  setBackgroundMode(PaletteBase);
	VokList.setGeometry( 0, 0, width(), height() );
	
	connect( &VokList, SIGNAL( enterPressedLastLine() ), SLOT( askForNewVokabel() ) );
	connect( &VokList, SIGNAL( justModified() ), SLOT( setModified() ) );
	connect( &VokList, SIGNAL( clipboardHasData( bool ) ), SLOT( setPasteFromClipboard( bool ) ) );
}

DokVokView::~DokVokView()
{
}

DokVokDoc *DokVokView::getDocument() const
{
  DokVokApp *theApp=(DokVokApp *) parentWidget();

  return theApp->getDocument();
}

void DokVokView::print(QPrinter *pPrinter)
{
  QPainter printpainter;
  printpainter.begin(pPrinter);
	
  // TODO: add your printing code here

  printpainter.end();
}


/** tells the Doc to append new Vokabel to list */
void DokVokView::askForNewVokabel()
{
 getDocument()->appendVokabel();
}


/** sets modified */
void DokVokView::setModified()
{
 getDocument()->setModified();
}


/** appends new vokabel */
void DokVokView::appendVokabel ( VVokabel *Vokabel, bool UpdateView = true )
{
	VokList.appendVokabel( Vokabel, UpdateView );
}


/** returns the current vok */
VVokabel *DokVokView::currentVok()
{
  return VokList.currentVok();
}

/** returns the first selected vok */
VVokabel *DokVokView::firstSelectedVok()
{
  return VokList.firstSelectedVok();
}

/** returns the first selected vok */
VVokabel *DokVokView::nextSelectedVok()
{
  return VokList.nextSelectedVok();
}


/** returns true if items are selected */
bool DokVokView::hasSelectedItems()
{
  return ( firstSelectedVok() );
  
//TODO: think about a better solution direct in VokList... counters or so?  
}

/** selects all */
void DokVokView::selectAll()
{
  VokList.selectAll();
}

/** deselects all */
void DokVokView::deselectAll()
{
  VokList.deselectAll();
}

/** inverts Selection */
void DokVokView::invertSelection()
{
  VokList.invertSelection();
}


/** sets the EditMode */
void DokVokView::setEditMode ( bool Editing = true )
{
  if( Editing )
    VokList.setPalette( EditingPalette );
  else
    VokList.setPalette( palette() );
    
  VokList.setEditMode( Editing ); 
}


void DokVokView::setLanguage( int Column, const char *Language )
{
  if( Language && (Language != "") )
  {
    VLanguageFile *LanguageFile = new VLanguageFile( Language, true );
    VokList.setColumnFont( Column, LanguageFile->font() );
    
    if( Column == TermColumn )
    {
      TypInfoList = LanguageFile->typInfoList();
      emit newTypInfoList( &TypInfoList );
    }
    delete LanguageFile;
    
  }
}
