/***************************************************************************
                          languageedit.h  -  description
                             -------------------
    begin                : Tue Mar 21 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LANGUAGESEDIT_H
#define LANGUAGESEDIT_H

#include <qgroupbox.h>
#include <qlineedit.h>
#include <qlabel.h>

#include "vdialog.h"
#include "vlangbox.h"
#include "vtypedit.h"

/**
  *@author Friedrich W. H. Kossebau
  */

class VLanguagesDialog : public VDialog  
{
   Q_OBJECT
  
  public: 
  	VLanguagesDialog(QWidget *parent=0, const char *name=0);
  	~VLanguagesDialog();
    
    void edit();
  
  protected:
    QHBoxLayout LanguageLayout;
    KButtonBox LanguageControl;
    QPushButton *New;
    QPushButton *Delete;    
    VLanguageBox LanguageBox;
    
    QGroupBox General;
    QVBoxLayout GeneralLayout;
    QLineEdit NameEdit;
    QLabel NameLabel;
    QLineEdit ShortEdit;
    QLabel ShortLabel;
    QHBoxLayout FontLayout;
    QPushButton FontSelect;
    QLineEdit FontEdit;
    QLabel FontLabel;
    
    VTypListEdit TypListEdit;
    
    VLanguageList *List;
  
  protected: // Protected methods
    /**  */
    void setLayout();
    void fill( int Index );
    void displayFont( QFont &Font );
  protected slots:
    void selected( int Index );
    void refreshBox( const char* Name );
    void selectFont();
    void createLanguage();
    void deleteLanguage();
  
};

#endif
