/***************************************************************************
                          vabfragedialog.h  -  description
                             -------------------
    begin                : Tue Jan 18 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VABFRAGEDIALOG_H
#define VABFRAGEDIALOG_H

#include <qdialog.h>
#include <qlayout.h> 
#include <qframe.h> 

#include <kbuttonbox.h>
#include <kaudio.h>
#include <kseparator.h>

#include "../vvokabellist.h"
#include "dokvokfigure.h"
#include "vabfrage.h"
#include "vchecker.h"


struct VQuestionSettings
{
  VCheckerSettings CheckerSettings;
  bool SecondChance;
  bool ShowCorrectedInput;
  int GroupSize;
};

/**
  *@author Friedrich W. H. Kossebau
  */

class VAbfrageDialog : public QDialog  
{
  Q_OBJECT
   
  public: 
  	VAbfrageDialog( VVokabelList *VokList, 
  	                QString GivenLanguage, QString AskLanguage,
                    VQuestionSettings *QuestionSettings,
  	                QWidget *parent=0, const char *name=0 );
  	~VAbfrageDialog();
    /**  */
    bool learn();
  
  protected: 
    /** sets the layout */
    void setLayout();
    void wait();
    void ask();
    void fillRoundList();
  
  protected slots: 
    void answerIs( VCorrectness );
    void reactionFinished();
    void reportWrongAnswer( const char *Report1, const char *Report2, const char *Report3 );
  
  protected: 
    // view design
    QVBoxLayout Layout;
    QFrame AbfrageRahmen;
    
	  QHBoxLayout RahmenLayout;
	  QVBoxLayout LeftLayout;
	  DokVokFigure Figure;
	  VAbfrage Abfrage;
	  QLabel ReportBox;

    KButtonBox Buttons;
  	QPushButton *Help;
  	QPushButton *Settings;
  	QPushButton *Cancel;
  	
	  // checking of knowledge	  
	  VChecker Checker;
    VQuestionSettings* QuestionSettings;
	  
    unsigned int GivenColumn;
    unsigned int AskedColumn;
    
    bool KnowledgeChange;
  	unsigned int Trial;
  	unsigned int Round;
  	
  	bool GoOn;
  	bool WasNoInput;
    
    // for vocabel list treatment
    VVokabelList *FullList;
    VVokabelList *RoundList;
    VVokabelList *UnknownList;
    VVokabel *Vokabel;
    
	  // sound support
//    KAudio AudioServer;
    QString RightSoundFileName;
    QString WrongSoundFileName;
   
  signals:
    void isModified();
  	
  public slots: // Public slots
    /** asks the next vocabel
    or opens new round if actual is done */
    void askNext();
    /**  */
    void editSettings();
  
};

#endif
