% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.JS.saveobj.R
\name{rk.JS.saveobj}
\alias{rk.JS.saveobj}
\title{Create JavaScript saveobject code from plugin XML}
\usage{
rk.JS.saveobj(
  pXML,
  R.objects = "initial",
  vars = TRUE,
  add.abbrev = FALSE,
  preview = FALSE,
  indent.by = rk.get.indent(),
  level = 2
)
}
\arguments{
\item{pXML}{Either an object of class \code{XiMpLe.doc} or \code{XiMpLe.node},
      or path to a plugin XML file.}

\item{R.objects}{Character vector,
      the names of the internal R objects to be saved. If not empty must have
the same length as <saveobject> nodes in the document, or be the keyword "initial",
      in which case the
\code{intital} attribute values of the nodes are used.}

\item{vars}{Logocal,
      whether the variables needed should also be defined in the JavaScript code.}

\item{add.abbrev}{Logical,
      if \code{TRUE} the JavaScript variables will all have a prefix with an
three letter abbreviation of the XML tag type to improve the readability of the code. But it's
probably better to add this in the XML code in the first place.}

\item{preview}{Logical,
      whether to prepare the JS code to be used in plugins with preview functionality, i.e.,
do not save objects while preview is active.}

\item{indent.by}{Character string used to indent each entry if \code{js=TRUE}.}

\item{level}{Integer, which indentation level to use, minimum is 1.}
}
\value{
A character vector.
}
\description{
Create JavaScript saveobject code from plugin XML
}
\seealso{
\href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
