% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i18n.R
\name{i18n}
\alias{i18n}
\title{Mark JavaScript strings as translatable}
\usage{
i18n(msgid, ..., context = NULL, plural = NULL, newline = "")
}
\arguments{
\item{msgid}{Either a character string, the message to be translated (if applicable,
      its singular form),
or an object of class \code{\link[base:noquote]{noquote}},
      which will be pasted as a \code{noquote()} function call.}

\item{...}{Either character string which will be pasted unquoted to be used in conjunctions with
placeholders in msgid,
      or XiMpLe.node objects of which the JavaScript variable name will be
used.}

\item{context}{Character string, optional context information for this string.}

\item{plural}{Character string for plural form of \code{msgid}, must at least include one
placeholder, and the first one has to represent an integer value in the dialog.}

\item{newline}{Character string,
      can be set to e.g. \code{"\n"} to force a newline after the call.}
}
\value{
An object of class \code{rk.JS.i18n}.
}
\description{
Similar to \code{\link[rkwarddev:echo]{echo}}, this function should help you to write
your JavaScript portions in R. Depending on the provided values for its arguments,
will return one of \code{i18n()}, \code{i18nc()}, \code{i18np()}, or \code{i18ncp()}.
}
\examples{
i18n("Select data")
i18n("Comparing a single pair", "n_pairs", plural="Comparing \%1 distinct pairs")

echo(i18n(noquote("A string I'll quote, later")))
}
