#!/bin/bash
  
clear
echo "******************************************************"
echo "*               Pysycache installation               *"
echo "******************************************************"
echo
echo "Don't forget to configure the prefix of linux/Makefile"
echo 

#the path where install pysycache 
PREFIX=/usr
SCOREDIR=/var/games
#the directory where copy the installation
#if you want to make your own package, you can make /tmp or 
#/mnt/mypackages
#if you want to install on your computer, you can make /
ROOT=/


#################################################################
# DON'T EDIT AFTER THESE LINES 
#################################################################


if [ $* ]
then PREFIX=$*
fi
echo ""
echo "Used PREFIX for installation is : $PREFIX"


BINDIR=$ROOT$PREFIX/games
MANDIR=$ROOT$PREFIX/man/man1
SHAREDIR=$ROOT$PREFIX/share/pysycache
GROUP="pysycache"
USER="pysycache"


#----------------------- creation des repertoires ---------------------------
echo
echo "Making directories for Pysycache -------------------------------------------"
mkdir -vp $BINDIR
mkdir -vp $MANDIR
mkdir -vp $SHAREDIR
mkdir -vp $ROOT/var/games/pysycache
mkdir -vp $ROOT/var/games/pysycache/users


#----------------------- recherche de l'utilisateur ---------------------------
set -e
CWD=`pwd`
USERID=`id | sed -e 's/).*//; s/^.*(//;'`
if [ "$USERID" != "root" ]; then
    echo ""
    echo "Be aware, you are not root... "
    echo "Maybe you have not correct rights to install pysycache ! "
fi


#----------------------- creation des comptes utilisateurs ---------------------------
echo ""
echo "Creation of users accounts  -----------------------------------------------------"
if [ -z "`grep $GROUP /etc/group`" ] 
       then
         echo "Creation of the group $GROUP :"
         groupadd $GROUP
       else
         echo "Warning : Group $GROUP already exists. Will not create it"
       fi

 if [ -z "`cut -d: -f1,1 /etc/passwd | grep $USER `" ] 
       then
         echo "Creation of the user $USER :"
	 useradd -g $GROUP -d /home/$USER $USER
       else
         echo "Warning : The user $USER already exists. Will not create it"
       fi


#----------------------- copie des fichiers ---------------------------
echo ""
echo "Copy of required files -----------------------------------------------------"
cp -rf pysycache/* $SHAREDIR

cd $CWD/linux
make 
make install

cd $CWD

echo ""
echo "Copy of documentation ------------------------------------------------------"
cp -rf ./linux/man/* $MANDIR

echo ""
echo "Copy menus entry for PySyCache ---------------------------------------------"
cp -rf ./linux/usr/*  $ROOT$PREFIX


#----------------------- copie des fichiers de configuration ---------------------
echo ""
echo "Copy of the configuration file ---------------------------------------------"
mkdir -vp $ROOT/etc/pysycache
cp -rf ./linux/etc/pysycache/* $ROOT/etc/pysycache


echo ""
echo "updates of rights ----------------------------------------------------------"

chown root:$GROUP -R $ROOT/etc/pysycache/
chmod 664 $ROOT/etc/pysycache/*

chown root:$GROUP -R $SHAREDIR/
#chown pysycache:pysycache  $SHAREDIR
chmod 755 $SHAREDIR/pysycache.py
chown root:$GROUP -R $ROOT/var/games/pysycache
chmod 775 $ROOT/var/games/pysycache
chmod 775 $ROOT/var/games/pysycache/users

echo ""
echo "End of installation"
echo "Don't forget to install your pack langage !"
echo "Don'f forget to add computer user in the pysycache group !"
echo ""

