#[cfg(test)]
mod test {
    use pwtool::*;

    #[test]
    fn test_acceptable_lowercase() {
        let test = "abc";
        let test_bad = "ABC";

        let set = Some(PwClass::Lower as u32);

        assert_eq!(valid_word(&test, set), true);
        assert_eq!(valid_word(&test_bad, set), false);
    }

    #[test]
    fn test_acceptable_uppercase() {
        let test = "ABC";
        let test_bad = "abc";

        let set = Some(PwClass::Upper as u32);

        assert_eq!(valid_word(&test, set), true);
        assert_eq!(valid_word(&test_bad, set), false);
    }

    #[test]
    fn test_acceptable_numeric() {
        let test = "abc1";
        let test_bad = "abcABC";

        let set = Some(PwClass::Num as u32);

        assert_eq!(valid_word(&test, set), true);
        assert_eq!(valid_word(&test_bad, set), false);
    }

    #[test]
    fn test_acceptable_extended() {
        let test_bad = "abcABC";

        let set = Some(PwClass::Ext as u32);

        for j in '!'..='/' {
            assert_eq!(valid_word(j.to_string().as_ref(), set), true);
        }

        assert_eq!(valid_word(&test_bad, set), false);
    }

    #[test]
    fn test_gen_salt() {
        use base64::prelude::*;

        let salt = gen_salt_str(40);

        let e = BASE64_STANDARD.decode(salt);

        assert!(e.is_ok());
    }

    #[test]
    fn test_postgres_pass() {
        let pass = postgres_pass("foo");
        assert!(pass.len() > 40);
    }

    #[test]
    fn test_mysql_pass() {
        let pass = mysql_pass("foo");
        assert!(pass.len() > 40);
    }

    #[test]
    fn test_mysql_caching_sha2_pass() {
        let pw = "test";
        let salt = "testsalttestsalttest";
        let pass = mysql_caching_sha2_pass_salt(pw, salt, 5);
        assert_eq!("nbYFPOYL.EkFOvR2sEnGxVOOXoQS7GweOApblsrm5e/", pass);
    }

    #[test]
    fn test_totp() {
        let mut c = Config::new();
        c.totp_key = Some("GOODTHINGS".to_string());
        c.totp_seconds = Some(1753443985);

        assert_eq!("756804", totp_string(&c));
    }
}
