/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPSession.h

	Contains:	Represents an RTSP session (duh), which I define as a complete TCP connection
				lifetime, from connection to FIN or RESET termination. This object is 
				the active element that gets scheduled and gets work done. It creates requests
				and processes them when data arrives. When it is time to close the connection
				it takes care of that.
	
	$Log: RTSPSession.h,v $
	Revision 1.2  1999/02/19 23:08:38  ds
	Created
	

*/

#ifndef __RTSPSESSION_H__
#define __RTSPSESSION_H__

#include "RTSPSessionInterface.h"
#include "RTSPRequestStream.h"
#include "RTSPRequest.h"
#include "Task.h"
#include "TimeoutTask.h"

class RTSPSession : public RTSPSessionInterface
{
public:

	RTSPSession();
	virtual ~RTSPSession();
	
private:

	SInt64 Run();
	
	//there is a stream and a request associated with this session
	RTSPRequestStream 	fStream;

	TimeoutTask			fTimeoutTask;//allows the session to be timed out
	UInt32				fTimeoutInMilSecs;
	
	//we want to take advantage of calling the RTSPRequest constructor
	//for each request in this session. But, we don't want to dynamically
	//allocate the memory (we know there is only one request at one time per
	//session). So, just allocate memory inline for the request object
	char				fRequestMem[sizeof(RTSPRequest)];

	// Used for debugging strange problems with the RTSP connection
	FILE*	fDebugFile;
};
#endif // __RTSPSESSION_H__

