/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPRequestStream.h

	Contains:	Provides a stream abstraction for RTSP. Given a socket, this object
				can read in data until an entire RTSP request header is available.
				(do this by calling ReadRequest). It handles RTSP pipelining (request
				headers are produced serially even if multiple headers arrive simultaneously),
				& RTSP request data.
					
	$Log: RTSPRequestStream.h,v $
	Revision 1.2  1999/02/19 23:08:33  ds
	Created
	

*/

#ifndef __RTSPREQUESTSTREAM_H__
#define __RTSPREQUESTSTREAM_H__


//INCLUDES
#include "StrPtrLen.h"
#include "TCPSocket.h"
#include "QTSS.h"

class RTSPRequestStream {
public:

	//CONSTRUCTOR / DESTRUCTOR
	RTSPRequestStream(TCPSocket* sock);
	~RTSPRequestStream() {}

	//ReadRequest
	//This function will not block.
	//Attempts to read data into the stream, stopping when we hit the EOL - EOL that
	//ends an RTSP header.
	//
	//Returns:			QTSS_NoErr:		Out of data, haven't hit EOL - EOL yet
	//					QTSS_RequestArrived: full request has arrived
	//					QTSS_NotEnoughSpace: ran out of buffer space
	//					QTSS_RequestFailed: if the client has disconnected
	//					QTSS_OutOfState: 
	QTSS_ErrorCode		ReadRequest(FILE* inDebugFile);
	
	//GetRequestBuffer
	//This returns a buffer containing the full client request. The length is set to
	//the exact length of the request headers. This will return NULL UNLESS this object
	//is in the proper state (has been initialized, ReadRequest has been called until it returns
	//RequestArrived)
	StrPtrLen*	GetRequestBuffer() 	{ return fRequestPtr; }

private:

		
	//CONSTANTS:
	enum
	{
		kRequestBufferSizeInBytes = 1024		//UInt32
	};
	
	//utility functions
	void 					Retreat(SInt32 length);
	SInt32					GetRetreatBytes(char *buffer, SInt32 length);

	TCPSocket*          	fSocket;
	SInt32					fRetreatBytes;
	char					fRequestBuffer[kRequestBufferSizeInBytes];
	StrPtrLen				fRequest;
	StrPtrLen*				fRequestPtr;
};
#endif
