/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPModule.cpp

	Contains:	Implemenation of RTSPModule objects
	
	$Log: RTSPModule.cpp,v $
	Revision 1.2  1999/02/19 23:08:29  ds
	Created
	

*/

#include "RTSPModule.h"
#include "RTSPProtocol.h"


RTSPModule**	RTSPModuleInterface::sRTSPModuleList = NULL;
UInt32			RTSPModuleInterface::sNumRTSPModules = 0;

void RTSPModuleInterface::FilterRequest(RTSPRequestInterface* inRequest)
{
#if DEBUG
	if (sNumRTSPModules > 0)
		Assert(sRTSPModuleList != NULL);
#endif
	for (UInt32 x = 0; ((x < sNumRTSPModules) && (!inRequest->HasResponseBeenSent())); x++)
	{
		if (NULL != sRTSPModuleList[x])
			if (sRTSPModuleList[x]->IsFilterModule())
				sRTSPModuleList[x]->FilterRequest(inRequest);
	}
}

void RTSPModuleInterface::LogError(	const RTSPModule::Verbosity inVerbosity, const char* inMessage)
{
#if DEBUG
	if (sNumRTSPModules > 0)
		Assert(sRTSPModuleList != NULL);
#endif
	for (UInt32 x = 0; x < sNumRTSPModules; x++)
	{
		if (NULL != sRTSPModuleList[x])
			if (sRTSPModuleList[x]->IsLoggingModule())
				sRTSPModuleList[x]->LogError(inVerbosity, inMessage);
	}

	//if this is a fatal error, just kill the server right here
	if (inVerbosity == RTSPModule::kFatal)
	{
		RTSPServerInterface::FatalErrorOccurred();
		//when we implement graceful shutdown, we'll have to do something like this
		//OS::SendStopRequest();
	}
}

RTSPProtocol::RTSPStatusCode RTSPModuleInterface::ProcessRequest(RTSPRequestInterface* inRequest)
{
	RTSPProtocol::RTSPStatusCode theError = RTSPProtocol::kSuccessOK;
	
	for (UInt32 x = 0; x < sNumRTSPModules; x++)
	{
		if (NULL != sRTSPModuleList[x])
		{
			if (sRTSPModuleList[x]->IsRequestProcessingModule())
				theError = sRTSPModuleList[x]->ProcessRequest(inRequest);
				
			if (theError != RTSPProtocol::kSuccessOK)
				return theError;
				
			if (inRequest->HasResponseBeenSent())
				return RTSPProtocol::kSuccessOK;
		}
	}
	return RTSPProtocol::kSuccessOK;
}

void RTSPModuleInterface::LogError(	const RTSPModule::Verbosity inVerbosity,
									const RTSPMessages::Message inMessage,
									const RTSPModule::ErrorNumber inNumber)
{
#if DEBUG
	if (sNumRTSPModules > 0)
		Assert(sRTSPModuleList != NULL);
#endif
	for (UInt32 x = 0; x < sNumRTSPModules; x++)
	{
		if (NULL != sRTSPModuleList[x])
			if (sRTSPModuleList[x]->IsLoggingModule())
				sRTSPModuleList[x]->LogError(inVerbosity, inMessage, inNumber);
	}

	//if this is a fatal error, just kill the server right here
	if (inVerbosity == RTSPModule::kFatal)
	{
		RTSPServerInterface::FatalErrorOccurred();
		//when we implement graceful shutdown, we'll have to do something like this
		//OS::SendStopRequest();
	}
}

void RTSPModuleInterface::SessionClosing(RTSPSessionInterface* inSession)
{
#if DEBUG
	if (sNumRTSPModules > 0)
		Assert(sRTSPModuleList != NULL);
#endif
	for (UInt32 x = 0; x < sNumRTSPModules; x++)
	{
		if (NULL != sRTSPModuleList[x])
			if (sRTSPModuleList[x]->IsSessionClosingModule())
				sRTSPModuleList[x]->SessionClosing(inSession);
	}
}

