/*
 * getopt.c
 * Written by Michael Kellner
 * Copyright 1999 by Apple Computer, Inc., all rights reserved
 *
 * $Log: /StreamingServers/proxy3/getopt.c $
		
		2     4/2/99 2:54 PM Mike Kellner
		better copyright
		
		1     2/26/99 10:36 AM Mike Kellner
		Adding subproject 'proxy3' to '$/StreamingServers'
		
		5     2/19/99 4:10 PM Mike Kellner
		use if defined(mac) rather than if mac
		
		4     2/15/99 2:16 PM Mike Kellner
		use global for finding the argument character ('-' for unix/mac, '/'
		for win) use DOS LF/CR 'cause mac can deal and win can't.
		
		3     2/12/99 2:53 PM Mike Kellner
		make more like unix getopt, rename to get_opt
		
		2     2/12/99 11:50 AM Mike Kellner
		for win & mac
 *
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#if defined(mac)
#include <types.h>
#endif

int get_opt(int argc, char *argv[], char *optList);

char *optarg = NULL;
char *whatOption = NULL;
int currentOpt = 0;
int optind = 1;
extern char gOptionsChar;

/* compareOptionString takes an option parameter with the following format:
 *  -REQuired  : the characters in CAPS are required to match.
 */
static int compareOptionString(char *option, char *compareit) {
	int i, l1, l2;

	l1 = strlen(option);
	l2 = strlen(compareit);
	for (i=0; i<l2; i++) {
		if (option[i] == '\0')
			return -1;			/* option < compareit */
		if (tolower(option[i]) == tolower(compareit[i])) {
		}
		else {
			if (option[i] > compareit[i])
				return 1;		/* option > compareit */
			else
				return -1;		/* option < compareit */
		}
	}
	/* if we got here, all of the characters in compareit are in option. */
	/* now we've got to check if there are any more required characters. */
	if (l1 > l2) {			/* only need to check if option is longer than compareit */
		if (option[l2] == toupper(option[l2]))
			return 1;		/* there was an additional character[s] needed. */
	}

	/* if we got here, then all is hunky dory and we got the required stuff. */
	return 0;
}

int get_opt(int argc, char *argv[], char *optList) {
	char	option[256];
	int		l, i, c, opt;

	currentOpt = optind;
	optind++;
	if (currentOpt >= argc) {
		return EOF;
	}
	optarg = NULL;
	whatOption = argv[currentOpt];

	if (whatOption[0] != gOptionsChar) {
		optarg = whatOption;
		return 0;
	}
	l = strlen(optList);
	i = 1;
	c = 0;
	opt = 1;
	option[c++] = gOptionsChar;
	while (i<=l) {
		if (optList[i] == gOptionsChar) {
			option[c++] = '\0';
//			if (strncasecmp(option, whatOption, strlen(whatOption)) == 0)
			if (compareOptionString(option, whatOption) == 0)
//				return opt;
				return option[1];
			c = 1;		// reset option string to '-' since we've just seen it
			opt++;		// check next option
		}
		else if (optList[i] == ':') {
			option[c++] = '\0';
//			if (strncasecmp(option, whatOption, strlen(whatOption)) == 0) {
			if (compareOptionString(option, whatOption) == 0) {
				currentOpt++;	optind++;
				optarg = argv[currentOpt];
//				return opt;
				return option[1];
			}
			c = 1;		// reset option string to '-'
			opt++;		// check next option
			i++;		// pass over the :
			if (optList[i] == gOptionsChar) {
				   ;			// this is where we want to be
			}
			else if (optList[i] == '\0') {
//				return EOF;		// this was the last option to check
				return 0;		// this was the last option to check
			}
			else {
				fprintf(stderr, "Malformed getopt string '%s': character %d is '%c' was expecting %c\n", optList, i, optList[i], gOptionsChar);
				return 0;
			}

		}
		else if (optList[i] == '\0') {
			option[c++] = '\0';
//			if (strncasecmp(option, whatOption, strlen(whatOption)) == 0) {
			if (compareOptionString(option, whatOption) == 0) {
//				return opt;
				return option[1];
			}
			optarg = argv[currentOpt];
//			return EOF;		// didn't find anything, return EOF
			return 0;		// didn't find anything, return EOF
		}
		else {
			option[c++] = optList[i];
		}
		i++;
	}

	optarg = argv[currentOpt];
	return 0;
}

