/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
// $Id: QTTrack.h,v 1.14 1999/05/20 21:29:10 serenyi Exp $
//
// QTTrack:
//   The central point of control for a track in a QTFile.

#ifndef QTTrack_H
#define QTTrack_H


//
// Includes
#include "QTAtom_dref.h"
#include "QTAtom_elst.h"
#include "QTAtom_mdhd.h"
#include "QTAtom_tkhd.h"
#include "QTAtom_stco.h"
#include "QTAtom_stsc.h"
#include "QTAtom_stsd.h"
#include "QTAtom_stss.h"
#include "QTAtom_stsz.h"
#include "QTAtom_stts.h"


//
// External classes
class QTFile;
class QTFile_FileControlBlock;
class QTAtom_stsc_SampleTableControlBlock;
class QTAtom_stts_SampleTableControlBlock;


//
// QTTrack class
class QTTrack {

public:
	//
	// Class error codes
	enum ErrorCode {
		errNoError					= 0,
		errInvalidQuickTimeFile		= 1,
		errParamError				= 2,
		errIsBFrame					= 3,
		errInternalError			= 100
	};


public:
	//
	// Constructors and destructor.
						QTTrack(QTFile * File, QTFile::AtomTOCEntry * trakAtom,
							   bool Debug = false, bool DeepDebug = false);
	virtual				~QTTrack(void);


	//
	// Initialization functions.
	virtual	ErrorCode	Initialize(void);

	//
	// Accessors.
	inline	bool		IsInitialized(void) { return fIsInitialized; }
	
	inline	char *		GetTrackName(void) { return (fTrackName ? fTrackName : ""); }
	inline	UInt32		GetTrackID(void) { return fTrackHeaderAtom->GetTrackID(); }
	inline	UInt32		GetCreationTime(void) { return fTrackHeaderAtom->GetCreationTime(); }
	inline	UInt32		GetModificationTime(void) { return fTrackHeaderAtom->GetModificationTime(); }
	inline	UInt32		GetDuration(void) { return fTrackHeaderAtom->GetDuration(); }
	inline	Float64		GetTimeScale(void) { return fMediaHeaderAtom->GetTimeScale(); }
	inline	Float64		GetTimeScaleRecip(void) { return fMediaHeaderAtom->GetTimeScaleRecip(); }
	inline	Float64		GetDurationInSeconds(void) { return GetDuration() / (Float64)GetTimeScale(); }
	inline	UInt32		GetFirstEditMovieTime(void)
											  { if(fEditListAtom != NULL) return fEditListAtom->FirstEditMovieTime();
												else return 0; }
	inline	UInt32		GetFirstEditMediaTime(void) { return fFirstEditMediaTime; }
	
	//
	// Sample functions
	inline	bool		SampleNumberToChunkNumber(UInt32 SampleNumber, UInt32 *ChunkNumber = NULL, UInt32 *SampleDescriptionIndex = NULL, UInt32 *SampleOffsetInChunk = NULL,
												  QTAtom_stsc_SampleTableControlBlock * STCB = NULL)
												 { return fSampleToChunkAtom->SampleNumberToChunkNumber(SampleNumber, ChunkNumber, SampleDescriptionIndex, SampleOffsetInChunk, STCB); }
	inline	bool		ChunkOffset(UInt32 ChunkNumber, UInt32 *Offset = NULL) { return fChunkOffsetAtom->ChunkOffset(ChunkNumber, Offset); }
	inline	bool		SampleSize(UInt32 SampleNumber, UInt32 *Size = NULL) { return fSampleSizeAtom->SampleSize(SampleNumber, Size); }

	virtual	bool		GetSampleInfo(UInt32 SampleNumber, UInt32 * const Length, UInt64 * const Offset = NULL, UInt32 * const SampleDescriptionIndex = NULL,
									  QTAtom_stsc_SampleTableControlBlock * STCB = NULL);
	virtual	bool		GetSampleMediaTime(UInt32 SampleNumber, UInt32 * const MediaTime,
										   QTAtom_stts_SampleTableControlBlock * STCB = NULL);
	virtual	bool		GetSample(UInt32 SampleNumber, char * Buffer, UInt32 * Length,
								  QTFile_FileControlBlock * FCB = NULL, QTAtom_stsc_SampleTableControlBlock * STCB = NULL);

	virtual	bool		GetSampleNumberFromMediaTime(UInt32 MediaTime, UInt32 * const SampleNumber,
													 QTAtom_stts_SampleTableControlBlock * STCB = NULL);

	virtual	void		GetPreviousSyncSample(UInt32 SampleNumber, UInt32 * SyncSampleNumber)
											 { if(fSyncSampleAtom != NULL) fSyncSampleAtom->PreviousSyncSample(SampleNumber, SyncSampleNumber);
											   else *SyncSampleNumber = SampleNumber; }
	virtual	void		GetNextSyncSample(UInt32 SampleNumber, UInt32 * SyncSampleNumber)
										  { if(fSyncSampleAtom != NULL) fSyncSampleAtom->NextSyncSample(SampleNumber, SyncSampleNumber);
											else *SyncSampleNumber = SampleNumber + 1; }

	//
	// Read functions.
	inline	bool		Read(UInt32 SampleDescriptionID, UInt64 Offset, char * const Buffer, UInt32 Length,
							 QTFile_FileControlBlock * FCB = NULL)
							{ return fDataReferenceAtom->Read(fSampleDescriptionAtom->SampleDescriptionToDataReference(SampleDescriptionID), Offset, Buffer, Length, FCB); }

	//
	// Debugging functions.
	virtual	void		DumpTrack(void);
	inline	void		DumpSampleToChunkTable(void) { fSampleToChunkAtom->DumpTable(); }
	inline	void		DumpChunkOffsetTable(void) { fChunkOffsetAtom->DumpTable(); }
	inline	void		DumpSampleSizeTable(void) { fSampleSizeAtom->DumpTable(); }


protected:
	//
	// Protected member variables.
	bool				fDebug, fDeepDebug;
	QTFile				*fFile;
	QTFile::AtomTOCEntry fTOCEntry;
	
	bool				fIsInitialized;

	QTAtom_tkhd			*fTrackHeaderAtom;
	char				*fTrackName;

	QTAtom_mdhd			*fMediaHeaderAtom;

	QTAtom_elst			*fEditListAtom;
	QTAtom_dref			*fDataReferenceAtom;

	QTAtom_stts			*fTimeToSampleAtom;
	QTAtom_stsc			*fSampleToChunkAtom;
	QTAtom_stsd			*fSampleDescriptionAtom;
	QTAtom_stco			*fChunkOffsetAtom;
	QTAtom_stsz			*fSampleSizeAtom;
	QTAtom_stss			*fSyncSampleAtom;

	UInt32				fFirstEditMediaTime;
};

#endif // QTTrack_H
