/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
// $Id: QTHintTrack.h,v 1.9 1999/06/04 20:57:15 serenyi Exp $
//
// QTHintTrack:
//   The central point of control for a hint track in a QTFile.

#ifndef QTHintTrack_H
#define QTHintTrack_H


//
// Includes
#include "QTTrack.h"
#include "QTAtom_hinf.h"
#include "QTAtom_tref.h"


//
// External classes
class QTFile;
class QTAtom_stsc_SampleTableControlBlock;
class QTAtom_stts_SampleTableControlBlock;


//
// Class state cookie
class QTHintTrack_HintTrackControlBlock {

public:
	//
	// Constructor and destructor.
						QTHintTrack_HintTrackControlBlock(QTFile_FileControlBlock * FCB = NULL);
	virtual				~QTHintTrack_HintTrackControlBlock(void);
	
	//
	// File control block
	QTFile_FileControlBlock	*fFCB;
	
	//
	// Sample Table control blocks
	QTAtom_stsc_SampleTableControlBlock * fstscSTCB;
	QTAtom_stts_SampleTableControlBlock * fsttsSTCB;
	
	//
	// Sample cache
	UInt32				fCachedSampleNumber;
	char *				fCachedSample;
	UInt32				fCachedSampleSize, fCachedSampleLength;

	//
	// Sample (description) cache
	UInt32				fCachedHintTrackSampleNumber, fCachedHintTrackSampleOffset;
	char *				fCachedHintTrackSample;
	UInt32				fCachedHintTrackSampleLength;
};


//
// QTHintTrack class
class QTHintTrack : public QTTrack {

public:
	//
	// Constructors and destructor.
						QTHintTrack(QTFile * File, QTFile::AtomTOCEntry * trakAtom,
							   bool Debug = false, bool DeepDebug = false);
	virtual				~QTHintTrack(void);


	//
	// Initialization functions.
	virtual	ErrorCode	Initialize(void);
	
	bool				IsHintTrackInitialized() { return fHintTrackInitialized; }

	//
	// Accessors.
			ErrorCode	GetSDPFileLength(int * Length);
			char *		GetSDPFile(int * Length);
			
	inline	UInt32		GetTotalRTPBytes(void) { return fHintInfoAtom ? fHintInfoAtom->GetTotalRTPBytes() : 0; }
	inline	UInt32		GetTotalRTPPackets(void) { return fHintInfoAtom ? fHintInfoAtom->GetTotalRTPPackets() : 0; }

	inline	UInt32		GetFirstRTPTimestamp(void) { return fFirstRTPTimestamp; }
	
	//
	// Sample functions
	virtual	bool		GetSamplePtr(UInt32 SampleNumber, char ** Buffer, UInt32 * Length,
									 QTHintTrack_HintTrackControlBlock * HTCB);

	//
	// Packet functions
	inline	UInt32		GetRTPTimescale(void) { return fRTPTimescale; }
	inline	UInt32		GetRTPTimestampRandomOffset(void) { return fTimestampRandomOffset; }
	inline	UInt16		GetRTPSequenceNumberRandomOffset(void) { return fSequenceNumberRandomOffset; }
	
	virtual	ErrorCode	GetNumPackets(UInt32 SampleNumber, UInt16 * NumPackets,
									  QTHintTrack_HintTrackControlBlock * HTCB = NULL);
	virtual	ErrorCode	GetPacket(UInt32 SampleNumber, UInt16 PacketNumber,
								  char * Buffer, UInt32 * Length,
								  Float64 * TransmitTime,
								  bool dropBFrames,
								  UInt32 SSRC = 0,
								  QTHintTrack_HintTrackControlBlock * HTCB = NULL);


	//
	// Debugging functions.
	virtual	void		DumpTrack(void);


protected:
	static const UInt16 kBFrameBitMask = 0x0002;
	//
	// Protected member variables.
	QTAtom_hinf			*fHintInfoAtom;
	QTAtom_tref			*fHintTrackReferenceAtom;
	
	QTTrack				**fTrackRefs;
	
	UInt32				fMaxPacketSize;
	UInt32				fRTPTimescale, fFirstRTPTimestamp;
	UInt32				fTimestampRandomOffset;
	UInt16				fSequenceNumberRandomOffset;
	
	QTHintTrack_HintTrackControlBlock	fDefaultHTCB;
	
	bool				fHintTrackInitialized;
};

#endif // QTHintTrack_H
