/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
// SimpleParse:

#ifndef SDPGen_H
#define SDPGen_H

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>

#if (__MACOS__)
	#include "bogusdefs.h"
#endif

#if (! __MACOS__)
	#include <sys/types.h>
	#include <sys/time.h>
	#include <sys/errno.h>
	#include <arpa/inet.h>
	#include <sys/socket.h>
	#include <netinet/in.h>
	#include <sys/utsname.h>
	#include <arpa/inet.h>
	#include <netdb.h>
	#include <sys/ioctl.h>
	#include <unistd.h>
	#include <netinet/in.h>
	#include <net/if.h>
#endif

#include "playlist_SimpleParse.h"
#include "QTRTPFile.h"


class SDPGen
{
	enum {eMaxSPDFileSize = 10240};
#if __MACOS__
	enum {ePath_Separator = ':', eExtension_Separator = '.'};
#else
	enum {ePath_Separator = '/', eExtension_Separator = '.'};

#endif
	
	private:
		char *fSDPFile;
		
	protected: 
		QTRTPFile		fRTPFile;
				bool	fKeepTracks;
		 		short 	AddToBuff(char *aSDPFile, short currentFilePos, char *chars);
		 		UInt32	RandomTime(void);
		  		short	GetNoExtensionFileName(char *pathName, char *result, short maxResult);
				short	GetLocalAddrStr(char *returnStr, short maxSize);
				char 	*Process(char *sdpFileName, char * basePort, char *ipAddress, char *anSDPBuffer, int *error);
		
	public: 
			 SDPGen() : fSDPFile(NULL), fKeepTracks(false), fSDPFileCreated(false) {	QTRTPFile::Initialize(); };
			~SDPGen() { if (fSDPFile) delete fSDPFile; };
			void KeepTracks(bool enabled) { fKeepTracks = enabled;} ;
			int Run( 	  char *movieFilename = NULL
					, char *sdpFilename = NULL
					, char *basePort = NULL 
					, char *ipAddress = NULL
					, char *buff = NULL
					, short buffSize = 0
					, bool overWriteSDP = false
				); 
				
			bool	fSDPFileCreated;
};

#endif

