/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		StringTranslator.h

	Contains:	Static utilities for translating strings from one encoding scheme to
				another. For example, routines for encoding and decoding URLs
				
	$Log: StringTranslator.h,v $
	Revision 1.2  1999/02/19 23:13:21  ds
	Created
	
	
*/

#ifndef __STRINGTRANSLATOR_H__
#define __STRINGTRANSLATOR_H__

#include "QTSS.h"
#include "OSHeaders.h"

#define STRINGTRANSLATORTESTING 0

class StringTranslator
{
	public:
	
		//DecodeURL:
		//If successful, returns the length of the destination string.
		//If failure, returns an QTSS errorcode: QTSS_BadURLFormat, QTSS_NotEnoughSpace,
		//QTSS_BadArgument
		static SInt32	DecodeURL(const char* inSrc, SInt32 inSrcLen, char* ioDest, SInt32 inDestLen);
		
#if STRINGTRANSLATORTESTING
		static bool		Test();
#endif	
};
#endif // __STRINGTRANSLATOR_H__

