/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		SessionDictionary.cpp

	Contains:	
						
	$Log: SessionDictionary.cpp,v $

	Created: Tue, Mar 2, 1999 @ 4:23 PM
*/


#include "SessionDictionary.h"
#include "MyAssert.h"

SessionDictionary::SigAndID SessionDictionary::sSigAndValueMap[kStdSignatureCount] = {
														{ SessionDictionary::kVideoCodecNameSig, 0},
														{ SessionDictionary::kAudioCodecNameSig, 0},
														{ SessionDictionary::kMovieDurationSig, 0},
														{ SessionDictionary::kMovieSizeInBytesSig, 0},
														{ SessionDictionary::kLastRTSPURLSig, 0},
														{ SessionDictionary::kLastRTSPUserAgentSig, 0}
													};


static DictValueIDManager sSessionDictValueIDManager;
SessionDictionary::StaticInit SessionDictionary::sStaticInit;


SessionDictionary::StaticInit::StaticInit()
{
	if (sSigAndValueMap[0].valueID == 0)	//hasn't been initialized yet
	{
		//Initialize the dictionary with NULL values..
		for (unsigned int i = 0; i < sizeof(sSigAndValueMap) / sizeof(SigAndID); i++)
		{
			sSigAndValueMap[i].valueID = sSessionDictValueIDManager.GenerateIDForSignature(sSigAndValueMap[i].valueSignature);
		}	
	}
}


SessionDictionary::SessionDictionary() : Dictionary(&sSessionDictValueIDManager)
{}


SessionDictionary::~SessionDictionary()
{
}

void SessionDictionary::SetStandardValue(UInt32 inStdValueIndex, const void* inValueBuffer, UInt32 inBufferLen)
{
	this->SetValue( sSigAndValueMap[inStdValueIndex].valueID, inValueBuffer, inBufferLen );
}


void* SessionDictionary::GetStandardValue(UInt32 inStdValueIndex, void* ioValueBuffer, UInt32 inBufferLen, UInt32* ioValueLen)
{
	this->GetValue( sSigAndValueMap[inStdValueIndex].valueID, ioValueBuffer, inBufferLen, ioValueLen );
	
	return ioValueBuffer;
}

UInt32 SessionDictionary::GetStandardUInt32Value(UInt32 inStdValueIndex, bool* ioWasFound)
{
	UInt32 uint32Val = 0;
	UInt32 actualValueLen = 0;

	uint32Val = *(UInt32*)(this->GetStandardValue(inStdValueIndex, &uint32Val, sizeof(uint32Val), &actualValueLen));	
	if (ioWasFound != NULL)
	{
		*ioWasFound = (actualValueLen!= 0);
	}
	
	
	return uint32Val;
}

UInt16 SessionDictionary::GetStandardUInt16Value(UInt32 inStdValueIndex, bool* ioWasFound )
{
	UInt16 uint16Val = 0;
	UInt32 actualValueLen = 0;

	uint16Val = *(UInt16*)(this->GetStandardValue(inStdValueIndex, &uint16Val, sizeof(uint16Val), &actualValueLen));	
	if (ioWasFound != NULL)
	{
		*ioWasFound = (actualValueLen!= 0);
	}
	
	
	return uint16Val;
}






