/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTSPPlayListModule.h

	Contains:	A module that uses the stats information available in the server
				to present a web page containing that information. Uses the Filter
				module feature of the RTSP API.

	$Log: RTSPPlayListModule.h,v $
	Revision 1.6  1999/06/01 20:39:17  serenyi
	made linuxable
	
	Revision 1.5  1999/05/21 22:24:40  lecroy
	more RTSPPlayModule stuff
	changed IDForTag to GenerateIDForSignature
	added RTSPRequestInterface::GetTruncatedAbsoluteURL method
	
	Revision 1.4  1999/05/20 06:30:42  lecroy
	so, RTSPPlayModule seems to work - still needs a bunch of work in terms of modes, etc.
	
	Revision 1.3  1999/05/19 03:31:06  lecroy
	dfkjhsljhdslkghdslgh
	
	Revision 1.1  1999/02/26 05:14:57  cl
	Added HTTP stats (RTSPPlayListModule)
	
	

*/

#ifndef _RTSPPLAYLISTMODULE_H_
#define _RTSPPLAYLISTMODULE_H_

#include <time.h>

#include "RTSPModule.h"
#include "OS.h"

class PlayList;
class PlayListElement;

class RTSPPlayListModule : public RTSPModule
{
public:
	RTSPPlayListModule() : 
		fFirstPlayList(NULL) {fRollMask = kRequestProcessingModule | kSessionClosingModule;}
	virtual ~RTSPPlayListModule() {}

	
	virtual void  SessionClosing(RTSPSessionInterface* session);
	
	virtual RTSPProtocol::RTSPStatusCode ProcessRequest(RTSPRequestInterface* request);
	virtual bool  Initialize();
	RTSPProtocol::RTSPStatusCode DoRedirect(RTSPRequestInterface* request, char* inURL);



private:
	PlayList* GetPlayListFromPath(char* inFilePath);
	

	PlayList* fFirstPlayList;
	static const int kPlayListCacheSize = 5;
	
	static UInt32 sPlayListIndexDictID;
	static UInt32 sPlayListDictID;

};

class PlayList
{
public:

	//factory method
	static PlayList* NewPlayList(const char* inFilePath);

	PlayList(int inFileNodeID);
	virtual ~PlayList();
	
	ino_t GetFileID() {return fFileInode;}
	
	PlayList* GetNextPlayList() {return fNextPlayList;}
	void SetNextPlayList(PlayList* inPlayList) { fNextPlayList = inPlayList;}
	
		
	char* GetRedirectURL(int* inPlayIndex);
	bool ParseFile(int inFileDesc);
	int GetElementCount();
	
private:
	// File information
	ino_t		fFileInode;

	//
	PlayListElement* fFirstPlayListElement;	//simple linked list is definitely not a good idea here...

	PlayList*	fNextPlayList;	// linked list cache of play lists

};

class PlayListElement
{
public:
	PlayListElement(char* inURL, int inWeight);
	virtual ~PlayListElement();
	
	char* GetURL() {fLastAccessTime = time(NULL); return fURL;}
	int GetWeight() {return fWeight;}
	time_t GetLastAccessTime() {return fLastAccessTime;}
	
	PlayListElement* GetNextPlayListElement() {return fNextPlayListElement;}
	void SetNextPlayListElement(PlayListElement* inPlayListElement) { fNextPlayListElement = inPlayListElement;}

private:
	char* fURL;
	int	fWeight;
	time_t fLastAccessTime;
	
	PlayListElement* fNextPlayListElement;	//simple linked list is definitely not a good idea here...
};


#endif