/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTPInterfaceModule.cpp

	Contains:	Implementation of RTPInterfaceModule object.


	$Log: RTPInterfaceModule.cpp,v $
	Revision 1.2  1999/02/19 23:07:22  ds
	Created
	

*/

#include "RTPInterfaceModule.h"
#include "RTPSession.h"
#include "RTPModule.h"
#include "RTPServerInterface.h"
#include "OSRef.h"
#include "OS.h"

StrPtrLen RTPInterfaceModule::sPublicHeader("DESCRIBE, SETUP, PLAY, PAUSE, TEARDOWN, OPTIONS", 47);

RTSPProtocol::RTSPStatusCode RTPInterfaceModule::ProcessRequest(RTSPRequestInterface *request)
{
	//Just pass this request into the RTP server
	return RTPModuleInterface::ProcessRequest(request, request->GetHeaderValue(RTSPProtocol::kSessionHeader));
}

void RTPInterfaceModule::SessionClosing(RTSPSessionInterface* inSession)
{
	RTPModuleInterface::SessionClosing(inSession);
}



	
