/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
// $Id: QTAtom_hinf.h,v 1.2 1999/04/15 22:36:10 lecroy Exp $
//
// QTAtom_hinf:
//   The 'hinf' QTAtom class.

#ifndef QTAtom_hinf_H
#define QTAtom_hinf_H


//
// Includes
#include "QTFile.h"
#include "QTAtom.h"


//
// QTAtom class
class QTAtom_hinf : public QTAtom {

public:
	//
	// Constructors and destructor.
						QTAtom_hinf(QTFile * File, QTFile::AtomTOCEntry * Atom,
							   bool Debug = false, bool DeepDebug = false);
	virtual				~QTAtom_hinf(void);


	//
	// Initialization functions.
	virtual	bool		Initialize(void);

	//
	// Accessors.
	inline	UInt32		GetTotalRTPBytes(void) { return fTotalRTPBytes; }
	inline	UInt32		GetTotalRTPPackets(void) { return fTotalRTPPackets; }


	//
	// Debugging functions.
	virtual	void		DumpAtom(void);


protected:
	//
	// Protected member variables.
	UInt32		fTotalRTPBytes;
	UInt32		fTotalRTPPackets;
};

#endif // QTAtom_hinf_H
