/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */

#ifndef OSHeaders_H
#define OSHeaders_H

/* Macros */
#define QTASSERT(cond) if(!cond) *((char *)0) = 0;

/* Platform-specific components */
#ifdef __linux__
	/* Defines */
	#define HAVE_64BIT_PRINTF		1
	#define HAVE_64BIT_PRINTF_AS_LL	0

	/* Includes */
	#include <sys/types.h>
	
	/* Constants */
	#define QT_TIME_TO_LOCAL_TIME	(-2082844800)
	#define QT_PATH_SEPARATOR		'/'

	/* Typedefs */
	typedef unsigned char		UInt8;
	typedef signed char			SInt8;
	typedef unsigned short		UInt16;
	typedef signed short		SInt16;
	typedef unsigned long		UInt32;
	typedef signed long			SInt32;
	typedef signed long long	SInt64;
	typedef unsigned long long	UInt64;
	typedef float				Float32;
	typedef double				Float64;
	
	typedef unsigned long		FourCharCode;
	typedef FourCharCode		OSType;

	/* Nulled-out new() for use without memory debugging */
	#define NEW(t,c,v) new c v
	#define NEW_ARRAY(t,c,n) new c[n]

	#define thread_t	pthread_t
	//#define cthread_errno() errno
#elif __FreeBSD__
	/* Defines */
	#define HAVE_64BIT_PRINTF		1
	#define HAVE_64BIT_PRINTF_AS_LL	0

	/* Includes */
	#include <sys/types.h>
	
	/* Constants */
	#define QT_TIME_TO_LOCAL_TIME	(-2082844800)
	#define QT_PATH_SEPARATOR		'/'

	/* Typedefs */
	typedef unsigned char		UInt8;
	typedef signed char			SInt8;
	typedef unsigned short		UInt16;
	typedef signed short		SInt16;
	typedef unsigned long		UInt32;
	typedef signed long			SInt32;
	typedef signed long long	SInt64;
	typedef unsigned long long	UInt64;
	typedef float				Float32;
	typedef double				Float64;
	
	typedef unsigned long		FourCharCode;
	typedef FourCharCode		OSType;

	/* Nulled-out new() for use without memory debugging */
	#define NEW(t,c,v) new c v
	#define NEW_ARRAY(t,c,n) new c[n]
#elif __MACOS__
	/* Defines */
	#define HAVE_64BIT_PRINTF		0
	#define HAVE_64BIT_PRINTF_AS_LL	0
	
	/* Constants */
	#define QT_TIME_TO_LOCAL_TIME	(126115200)
	#define QT_PATH_SEPARATOR		':'
	
	/* Typedefs */
	typedef unsigned char		UInt8;
	typedef signed char			SInt8;
	typedef unsigned short		UInt16;
	typedef signed short		SInt16;
	typedef unsigned long		UInt32;
	typedef signed long			SInt32;
	typedef signed long long	SInt64;
	typedef unsigned long long	UInt64;
	typedef float				Float32;
	typedef short double		Float64;
	
	typedef unsigned long		FourCharCode;
	typedef FourCharCode		OSType;
	
	/* Nulled-out functions */
	#define htons(x) x
	#define htonl(x) x
	#define ntohs(x) x
	#define ntohl(x) x

	/* Nulled-out new() for use without memory debugging */
	#define NEW(t,c,v) new c v
	#define NEW_ARRAY(t,c,n) new c[n]
#elif __MacOSX__
	/* Defines */
	#define HAVE_64BIT_PRINTF		1
	#define HAVE_64BIT_PRINTF_AS_LL	0

	/* Includes */
	#include <sys/types.h>
	
	/* Constants */
	#define QT_TIME_TO_LOCAL_TIME	(-2082844800)
	#define QT_PATH_SEPARATOR		'/'

	/* Typedefs */
	typedef unsigned char		UInt8;
	typedef signed char			SInt8;
	typedef unsigned short		UInt16;
	typedef signed short		SInt16;
	typedef unsigned long		UInt32;
	typedef signed long			SInt32;
	typedef signed long long	SInt64;
	typedef unsigned long long	UInt64;
	typedef float				Float32;
	typedef double				Float64;
	
	typedef unsigned long		FourCharCode;
	typedef FourCharCode		OSType;

	#if __cplusplus
		#if QTFILE_MEMORY_DEBUGGING
			/* Function prototype for Denis' memory-debugging new() */
			void* operator new(size_t s, UInt32 tag);
			void* operator new[](size_t s, UInt32 tag);
			#define NEW(t,c,v) new (t) c v
			#define NEW_ARRAY(t,c,n) new (t) c[n]
		#else
			/* Nulled-out new() for use without memory debugging */
			#define NEW(t,c,v) new c v
			#define NEW_ARRAY(t,c,n) new c[n]
		#endif
	#endif
#elif defined(sun) // && defined(sparc)
	/* Defines */
	#define HAVE_64BIT_PRINTF		1
	#define HAVE_64BIT_PRINTF_AS_LL	1

	/* Includes */
	#include <sys/types.h>
	#include <sys/byteorder.h>
	
	/* Constants */
	#define QT_TIME_TO_LOCAL_TIME	(-2082844800)
	#define QT_PATH_SEPARATOR		'/'

	/* Typedefs */
	typedef unsigned char		bool;
	#define true				1
	#define false				0

	typedef unsigned char		UInt8;
	typedef signed char			SInt8;
	typedef unsigned short		UInt16;
	typedef signed short		SInt16;
	typedef unsigned long		UInt32;
	typedef signed long			SInt32;
	typedef signed long long	SInt64;
	typedef unsigned long long	UInt64;
	typedef float				Float32;
	typedef double				Float64;
	
	typedef unsigned long		FourCharCode;
	typedef FourCharCode		OSType;

	/* Nulled-out new() for use without memory debugging */
	#define NEW(t,c,v) new c v
	#define NEW_ARRAY(t,c,n) new c[n]

	#define thread_t	pthread_t
	#define cthread_errno() errno
#endif

#endif /* OSHeaders_H */
