
/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */



#include "BroadcastLog.h"

#include "PathDelimiter.h"


BroadcastLog::BroadcastLog( PLBroadcastDef*	broadcastParms ) 
			: RTSPRollingLog(true) 
{
	*mDirPath = 0;
	*mLogFileName = 0;
	
	if (broadcastParms->mLogging)
	{
		if (!::strcmp( broadcastParms->mLogging, "enabled" ) )
		{
			mWantsLogging = true;
			
			::strcpy( mDirPath, broadcastParms->mLogFile );
		
			char*	nameBegins = ::strrchr( mDirPath, kPathDelimiterChar );
			
			if ( nameBegins )
			{
				*nameBegins = 0;
				nameBegins++;
				::strcpy( mLogFileName, nameBegins );
				
				
			}
			else
			{	// it was just a file name, no dir spec'd
				::strcpy( mLogFileName, broadcastParms->mLogFile );
				*mDirPath = 0;
			
			}
		}
	}
}


void	BroadcastLog::LogInfo( const char* infoStr )
{
	// log a generic comment 
	char	dateBuff[80];
	
	if ( this->FormatDate( dateBuff ) )
	{	
		this->WriteToLog( "# ", false );
		this->WriteToLog( dateBuff, true );
		this->WriteToLog( " ", false );
		this->WriteToLog( infoStr, false );			
		this->WriteToLog( "\n", false );

	}
	
}


void BroadcastLog::LogMoviePlay( const char* path, const char* errStr )
{
	// log movie play info
	char	dateBuff[80];
	
	if ( this->FormatDate( dateBuff ) )
	{	
		this->WriteToLog( dateBuff, true );
		this->WriteToLog( " ", false );
		this->WriteToLog( path, false );
		this->WriteToLog( " ", false );
		
		if ( errStr )
		{	this->WriteToLog( "Error:", false );
			this->WriteToLog( errStr, false );
		}
		else
			this->WriteToLog( "OK", false );
			
		this->WriteToLog( "\n", false );

	}
	
}

