##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
Plone Article core classes for images and attachments and layout models
"""

from AccessControl import ClassSecurityInfo
import string
import random
import os
from Products.CMFCore import CMFCorePermissions
from AccessControl import Permissions, getSecurityManager, ClassSecurityInfo, Unauthorized
from OFS import Folder, Image, ObjectManager
from Products.ZAttachmentAttribute import ZAttachmentAttribute
from global_symbols import ArticleCore_editPermission
from Products.CMFCore.utils import getToolByName
from Products.PloneArticle.Installation import Installation


#                                                                           #
#                           MODEL SUPPORT                                   #
#                                                                           #


class ArticleModel(ObjectManager.ObjectManager):

    security = ClassSecurityInfo()
    
    # Init method
    security.declarePrivate('__init__')
    def __init__(self):
        """__init__(self)"""
        self.model = ''

    security.declareProtected(CMFCorePermissions.View, "getModel")
    def getModel(self):
        """
        getModel(self) => returns the Model id of the PloneArticle

        If the article has no model set, we fetch the default one.
        """
        model = getattr(self, 'model', None)
        
        # If we can't access the model template, we can't take the stored model
        if model:
            if not getattr(self, model, None):
                # Model not valid as template not accessible
                model = None
                
        # If the model exists, return it, otherwise take the default one
        if not model:
            model = self._getDefaultModel()
 
        return model

    security.declareProtected(CMFCorePermissions.View, "getModelPath")
    def getModelPath(self):
        """
        getModelPath(self, model) => returns the path where the macro for
                                     the model can be found
        """
        # The path expression used in PloneArticle_view
        model_path = 'here/%(template)s/macros/%(macro)s'
        template = self.getModel()
        
        # The standard name for the macro is different for Plone 1 or 2
        macro = 'PloneArticleModel'
        if self._isPlone2():
            # Macro for Plone 2
            macro = 'Plone2ArticleModel'
            
        return model_path % ({'template': template,'macro': macro})

    security.declareProtected(ArticleCore_editPermission, 'setModel')
    def setModel(self, model):
        """
        setModel(self) => sets the Model to serve as a layout for the PloneArticle
        """
        # Check lock status
        self.checkLockStatus()

        template = getattr(self, model, None)
        if template:
            self.model = model
        else:
            raise ValueError, "Invalid model: '%s'" % (model, )

    security.declareProtected(CMFCorePermissions.View, "getModelTitle")
    def getModelTitle(self, model):
        """
        getModelTitle(self) => returns the Model Title for the Model that serves as a layout for the PloneArticle
                               First takes the customized models and then falls back to the StockModels.
        """
        template = getattr(self, model, None)
        if template:
            modeltitle = template.title_or_id()
        else:
            raise "Template does not exist"
        return modeltitle

    def _getDefaultModel(self):
        """
        _getDefaultModel(self) => returns the default Model to serve as a layout for the PloneArticle
        """
        model = "PloneArticleModel"
        return model

    security.declarePrivate('isPlone2')
    def _isPlone2(self,):
        portal_url = getToolByName(self, 'portal_url')
        if 'portal_form_controller' in portal_url.getPortalObject().objectIds():
            return 1
        return 0
