##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
Plone Article with images and attachments and layout models
"""

from Globals import InitializeClass
from AccessControl import ClassSecurityInfo
import string
import random
import os

from Products.CMFCore.CMFCorePermissions import View, ManageProperties, ListFolderContents
from Products.CMFDefault.DublinCore import DefaultDublinCoreImpl
from Products.CMFCore.PortalContent import PortalContent
from Products.CMFCore import CMFCorePermissions
from AccessControl import Permissions, getSecurityManager, ClassSecurityInfo, Unauthorized
from OFS import Folder, Image, ObjectManager
from Products.ZAttachmentAttribute import ZAttachmentAttribute
from global_symbols import *
from ArticleCore import ArticleCore
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.utils import format_stx
from Products.CMFDefault.utils import html_headcheck
from DocumentTemplate.DT_Util import html_quote

from ArticleModel import ArticleModel
from ArticleAttachments import ArticleAttachments
from ArticleImages import ArticleImages
from ArticleLock import ArticleLock

# PloneArticle definition
# THIS PART IS FOR PLONE1 ONLY !
factory_type_information = {
  'id'             : 'PloneArticle',
  'portal_type'    : 'PloneArticle',
  'meta_type'      : 'PloneArticle',
  'description'    : 'A PloneArticle',
  'content_icon'   : 'PloneArticle.gif',                          # Icon has to be acquired from a skin folder
  'product'        : 'PloneArticle',
  'factory'        : 'addPloneArticle',
  'immediate_view' : 'PloneArticle_edit',
  'filter_content_types' : 0,                                   # This is for folderish types
  'allowed_content_types': (),                                  # If filter_content_types is true, this field can hold allowed meta_types
  'actions': (
    {
    'id'           : 'view',
    'name'         : 'View',
    'action'       : 'PloneArticle_view',
    'permissions'  : (CMFCorePermissions.View, ),
    'category'      : 'object',
    },
    {
    'id'           : 'edit',
    'name'         : 'Edit',
    'action'       : 'portal_form/PloneArticle_editForm',
    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
    'category'      : 'object',
    },
    {
    'id'           : 'image',
    'name'         : 'Images',
    'action'       : 'portal_form/PloneArticle_imageForm',
    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
    'category'      : 'object',
    },
    {
    'id'           : 'attach',
    'name'         : 'Attachments',
    'action'       : 'portal_form/PloneArticle_attachmentForm',
    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
    'category'      : 'object',
    },
    {
    'id'           : 'model',
    'name'         : 'Model',
    'action'       : 'portal_form/PloneArticle_modelForm',
    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
    'category'      : 'object',
    },
    {
    'id'            : 'metadata',
    'name'          : 'Properties',
    'action'        : 'metadata_edit_form',
    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
    'category'      : 'object',
    },
    ),
  }


# Plone2 FTI
factory_type_information2 = {
  'id'             : 'PloneArticle',
  'portal_type'    : 'PloneArticle',
  'meta_type'      : 'PloneArticle',
  'description'    : 'A PloneArticle',
  'content_icon'   : 'PloneArticle.gif',                          # Icon has to be acquired from a skin folder
  'product'        : 'PloneArticle',
  'factory'        : 'addPloneArticle',
  'immediate_view' : 'PloneArticle_edit2',
  'filter_content_types' : 0,                                   # This is for folderish types
  'allowed_content_types': (),                                  # If filter_content_types is true, this field can hold allowed meta_types
  'actions': (
    {
    'id'           : 'view',
    'name'         : 'View',
    'action'       : 'string:${object_url}/PloneArticle_view',
    'permissions'  : (CMFCorePermissions.View, ),
    'category'      : 'object',
    },
    {
    'id'           : 'edit',
    'name'         : 'Edit',
    'action'       : 'string:${object_url}/PloneArticle_editForm2',
    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
    'condition'     : 'object/hasLockToken',
    'category'      : 'object',
    },
    {
    'id'           : 'image',
    'name'         : 'Images',
    'action'       : 'string:${object_url}/PloneArticle_imageForm2',
    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
    'condition'     : 'object/hasLockToken',
    'category'      : 'object',
    },
    {
    'id'           : 'attach',
    'name'         : 'Attachments',
    'action'       : 'string:${object_url}/PloneArticle_attachmentForm2',
    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
    'condition'     : 'object/hasLockToken',
    'category'      : 'object',
    },
    {
    'id'           : 'model',
    'name'         : 'Model',
    'action'       : 'string:${object_url}/PloneArticle_modelForm2',
    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
    'condition'     : 'object/hasLockToken',
    'category'      : 'object',
    },
    {
    'id'            : 'metadata',
    'name'          : 'Properties',
    'action'        : 'string:${object_url}/metadata_edit_form',
    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
    'condition'     : 'object/hasLockToken',
    'category'      : 'object',
    },
    {
    'id'            : 'content_status_history',
    'name'          : 'State',
    'action'        : 'string:${object_url}/content_status_history',
    'condition'     : 'python:object and portal.portal_workflow.getTransitionsFor(object, object.getParentNode())',
    'permissions'   : (CMFCorePermissions.View,),
    'category'      : 'object_tabs',
    'visible'       : 0
    },
    {
    'id'            : 'toggle_article_lock',
    'name'          : 'Toggle Lock',
    'action'        : 'string:${object_url}/toggleArticleLock',
    'permissions'   : (CMFCorePermissions.View, ),
    'condition'     : 'python:object.canToggleLock()',
    'category'      : 'document_actions',
    },
    ),
  }
  

  
# The usual factory
def addPloneArticle(self, id, title = '', REQUEST = {}):
    """
    Factory method for a PloneArticle object
    """
    obj = PloneArticle(id, title)
    self._setObject(id, obj)
    getattr(self, id)._post_init()
    
    if REQUEST.has_key('RESPONSE'):
        return REQUEST.RESPONSE.redirect(self.absolute_url() + '/manage_main')

class PloneArticle(ArticleCore, ArticleModel, ArticleAttachments, ArticleImages, ArticleLock, DefaultDublinCoreImpl, PortalContent, ):
    """PloneArticle class"""

    #                                                                           #
    #                            BASIC CLASS BEHAVIOUR                          #
    #                                                                           #

    __implements__ = ( PortalContent.__implements__
                     , DefaultDublinCoreImpl.__implements__
                     )

    meta_type = factory_type_information['meta_type']                   # Has not to be the same as FTI but it is the most usual case.
    _isDiscussable = 1
    manage_options = PortalContent.manage_options

    # Standard security settings
    security = ClassSecurityInfo()
    security.declareObjectProtected(CMFCorePermissions.View)            # $$$ Is this clever ? Isn't it better to make the object private ?
                                                                        # This method makes all class properties & methods protected by View by default
    # Init method
    security.declarePrivate('__init__')
    def __init__(self, id, title='', **kwargs):
        """__init__(self, id, title='')"""
##        PortalContent.__init__(self,)
        DefaultDublinCoreImpl.__init__(self,)
        ArticleCore.__init__(self, id, **kwargs)
        ArticleModel.__init__(self, **kwargs)
        ArticleAttachments.__init__(self, **kwargs)
        ArticleImages.__init__(self, **kwargs)
        ArticleLock.__init__(self, **kwargs)

    security.declarePrivate('_post_init')
    def _post_init(self):
        """
        _post_init(self) => Post-init method (that is, method that is called AFTER the class has been set into the ZODB)
        """
        ArticleCore._post_init(self)

    # Dummy permission methods.
    # This is done to "create" the permissions
    security.declareProtected(PloneArticle_editPermission, "dummyEdit")
    security.declareProtected(PloneArticle_lockPermission, "dummyLock")



# CLASS instanciation
InitializeClass(PloneArticle)

