from Products.PlugIns import PlugInGroup, PlugInContainer, PlugInFinder, MakePICBase
from Providers import ProviderContainer
from Globals import HTMLFile, default__class_init__
_marker = []

class Specialist(ProviderContainer, PlugInContainer):

    """Specialist - provides implementation services for an abstract type"""

    meta_type = "Specialist"

    RacksGroup = PlugInGroup('RacksGroup',['Rack'],
            attr='rackList', title='Racks')
            
    __plugin_groups__ = (RacksGroup,) + ProviderContainer.__plugin_groups__

    rackList = ()

    def __bobo_traverse__(self, REQUEST, name):
        ob = getattr(self, name, _marker)
        if ob is _marker:
            ob = self.getItem(name)
            if ob is not None:
                return ob
            raise 'NotFound'
        return ob

    def getItem(self, key):
        """Get an item"""
        if hasattr(self.aq_base,'retrieveItem'):
            return self.retrieveItem(key=key) # XXX need DTML check?

        for rack in self.rackList:
            item = rack.__of__(self).getItem(key)
            if item is not None: return item

    def newItem(self, key=None):
        """Create a new item"""
        # Default use first rack
        return self.rackList[0].__of__(self).newItem(key)

    def manage_refreshPlugIns(self, REQUEST=None):
        """Update plugin registries"""
        r = PlugInContainer.manage_refreshPlugIns(self,REQUEST)

        # Pass on word to the racks
        for rack in self.rackList:
            rack.__of__(self).manage_refreshPlugIns()
            
        return r

    __ac_permissions__ = (
        ('Access contents information', ('getItem',)),
        ('Add Items to Racks', ('newItem',)),
    )


default__class_init__(Specialist); MakePICBase(Specialist)


manage_addSpecialistForm = HTMLFile('addSpecialist', globals(),
    RacksMetaTypes = PlugInFinder(Specialist.RacksGroup))

def manage_addSpecialist(self, id, title='', rack='', REQUEST=None):
    """Add a Specialist"""
    ob = Specialist(id, title)
    self._setObject(id, ob)
    ob = ob.__of__(self)
    
    if rack:
        ob.RacksGroup._constructPlugIn(rack, id='defaultRack')
    
    if REQUEST: return self.manage_main(self,REQUEST,update_menu=1)









def initialize(context):

    context.registerPIContainerBase(Specialist)

    context.registerClass(
        Specialist,
        permission = 'Add Specialists',
        constructors = (manage_addSpecialistForm,
                        manage_addSpecialist),
        icon = 'www/specialist.gif',
    )


