from Products.ZPatterns.Providers import NullProvider
from Products.ZPatterns.Proxy import ProxyManager
from Products.ZPatterns.PlugIns import PlugIn, defaultConstructors
from Compiler import compile
from Globals import HTMLFile, default__class_init__
from DateTime.DateTime import DateTime
from OFS.SimpleItem import Item


class SSMethod(PlugIn, NullProvider, ProxyManager):

    """SkinScript Method"""
    
    __plugin_kind__ = "Attribute Provider"
    meta_type = "SkinScript Method"

    manage_options = (
        {'label':'Edit', 'action':'manage_main', 'help': ('ZPatterns','SkinScriptSyntax.stx')},
        {'label':'Upload', 'action':'manage_uploadForm'},
    ) + ProxyManager.manage_options + Item.manage_options

    
    text = ''
    _providers = ()
    
    def _propertiesChanged(self):
        providers = self._providers = compile(self.text)
        
        for p in providers:
            p._proxy_roles = self._proxy_roles
            p.id = '%s, line %d' % (self.id,p.lineno); p.title = self.title

        self.aq_inner.aq_parent.manage_refreshPlugIns()
            
    def _getProviders(self):
        return self._providers





    manage_main=HTMLFile('methodEdit',globals())
    
    def manage_edit(self, title, text, height=None, width=None,
                    dtpref_cols='50', dtpref_rows='20', REQUEST=None):
        """Change the method"""
        self._validateProxy(REQUEST)
        if height is not None or width is not None:
            return self._er(title, text, height, width, dtpref_cols,
                            dtpref_rows, REQUEST)

        if type(text) is not type(''):
            text = text.read()
            
        self.text, self.title = text, title

        self._propertiesChanged()

        if REQUEST:
            message = "Contents updated."
            return self.manage_main(self, REQUEST, manage_tabs_message=message)


    def _er(self, title, text, height,width, dtpref_cols,dtpref_rows, REQUEST):
        szch = {'+': 5, '-': -5, None: 0}
        try: rows = int(height)
        except: rows = max(1, int(dtpref_rows) + szch.get(height, 0))
        try: cols = int(width)
        except: cols = max(40, int(dtpref_cols) + szch.get(width, 0))
        e = (DateTime('GMT') + 365).rfc822()
        resp = REQUEST['RESPONSE']
        resp.setCookie('dtpref_rows',str(rows),path='/',expires=e)
        resp.setCookie('dtpref_cols',str(cols),path='/',expires=e)
        return self.manage_main(self, REQUEST, title=title, 
            text=text, dtpref_cols=cols, dtpref_rows=rows)







    manage_uploadForm=HTMLFile('ssUpload',globals())

    def manage_upload(self,file='', REQUEST=None):
        """Replace the contents of the method with the text in file."""
        self._validateProxy(REQUEST)
        if type(file) is not type(''): file=file.read()
        self.text = file; self._propertiesChanged()
        
        if REQUEST:
            return self.manage_main(self, REQUEST,
                manage_tabs_message="Contents updated.")

    def PUT(self, REQUEST, RESPONSE):
        """Handle HTTP PUT requests."""
        self.dav__init(REQUEST, RESPONSE)
        body=REQUEST.get('BODY', '')
        self._validateProxy(REQUEST)
        self.text=body; self._propertiesChanged()
        RESPONSE.setStatus(204)
        return RESPONSE

    def manage_proxy(self, roles=(), REQUEST=None):
        "Change Proxy Roles"
        r = ProxyManager.manage_proxy.im_func(self,roles,REQUEST)

        # Update proxy roles on providers, and reload them into parent
        for p in self._providers: p._proxy_roles = self._proxy_roles
        self.aq_inner.aq_parent.manage_refreshPlugIns()

        return r

    __ac_permissions__ = (
        ('Change proxy roles', ('manage_proxy')),
        ('View management screens',  ('manage_uploadForm','manage_main')),
        ('Change SkinScript methods',('manage_upload','PUT','manage_edit')),
    )


default__class_init__(SSMethod)


def initialize(context):
    context.registerPlugInClass(
        SSMethod,
        permission = 'Add SkinScript Methods',
        constructors = defaultConstructors(SSMethod,globals()),
        icon = 'www/SkinScriptMethod.gif'
    )

