#import "NSObjectObjcUnitAdditionsTest.h"

#import <ObjcUnit/NSObject-ObjcUnitAdditions.h>

@interface TestClass : NSObject
- (void)method1;
- (void)method2;
- (void)method3;
@end

@implementation TestClass
- (void)method1 { }
- (void)method2 { }
- (void)method3 { }
@end

@interface SubTestClass : TestClass
- (void)method3;
- (void)method4;
@end

@implementation SubTestClass
- (void)method3 { }
- (void)method4 { }
@end

@implementation NSObjectObjcUnitAdditionsTest

- (int)methodCountForClass:(Class)aClass {
    return [(NSArray *)[aClass performSelector:@selector(instanceMethodNames)] count];
}

- (void)testInstanceMethodNames {
    int inheritedMethodCount;
    NSArray *methodNames;
    
    inheritedMethodCount = [self methodCountForClass:[NSObject class]];
    [self assertTrue:(inheritedMethodCount > 0)];
        
    [self assertInt:([self methodCountForClass:[TestClass class]] - inheritedMethodCount) equals:3];
    
    methodNames = [TestClass instanceMethodNames];
    [self assertTrue:[methodNames containsObject:@"method1"]];
    [self assertTrue:[methodNames containsObject:@"method2"]];
    [self assertTrue:[methodNames containsObject:@"method3"]];
}

- (void)testInstanceMethodNamesSubClass {
    int inheritedMethodCount;
    NSArray *methodNames;

    inheritedMethodCount = [self methodCountForClass:[NSObject class]];
    [self assertInt:([self methodCountForClass:[SubTestClass class]] - inheritedMethodCount) equals:4];

    methodNames = [SubTestClass instanceMethodNames];
    [self assertTrue:[methodNames containsObject:@"method2"]];
    [self assertTrue:[methodNames containsObject:@"method3"]];
    [self assertTrue:[methodNames containsObject:@"method4"]];
}

- (void)testInstanceMethodNamesOrdering {
    NSEnumerator *reverseEnumerator = [[SubTestClass instanceMethodNames] reverseObjectEnumerator];
    [self assertString:[reverseEnumerator nextObject] equals:@"method4"];
    [self assertString:[reverseEnumerator nextObject] equals:@"method3"];
    [self assertString:[reverseEnumerator nextObject] equals:@"method2"];
    [self assertString:[reverseEnumerator nextObject] equals:@"method1"];
}

@end
