#! /usr/bin/perl -w


# Ham Radio Contest Country check module sections.pm by PA0R.

# This program is published under the GPL license.
#   Copyright (C) 2005, 2006
#       Rein Couperus PA0R (rein@couperus.com)
# 
# *    sections.pm is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    sections.pm is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Date: 04-04-06

#################################################
# API:
# add, check, delete sections in hash per band... 
# Input is section and band (int)
# Output is nr. of records per section
#
# addsection($section, $band);
# checksection($section, $band)
# delsection($section, $band)
# 
# @cnts = countsections() (160, 80, 40,20, 15,10)
#################################################

use Switch;


########### initialize the hash ################
@sections = initsectionhash();

{ # start outer block

@sectionlist = ();
%valid_sections = ();
#################################################
sub initsectionhash {
#################################################
	eval {
		open ($fh, "$ENV{HOME}/.xtlf/sections") or die "Cannot find sections!";
		@sectionlist = <$fh>;
		close $fh;
		foreach $section_in_list (@sectionlist) {
			chomp $section_in_list;
			$valid_sections{$section_in_list} = 1; # fill the valid sections hash
		}	
	};
	if ($@) {
		print "$@\n";
	}
	
	return @sectionlist;
}


#################################################
sub getsectioninfo {
#################################################

	return @sections;
}

#################################################
sub section_valid {
#################################################
	my ($section, %sections) = @_;

	if (defined ($valid_sections{$section})) {
		return 1;
	} else {
		return 0;	# not found
	}
}

#################################################
sub addsection {
#################################################
	my ($section, $band) = @_;

	if ($section =~ /([A-Z]).*/) {
		; # continue
	} else { return 0; } # is serial nr.
	switch($band) {
		case "160"	{$r = addsection_160($section);}
		case " 80"	{$r = addsection_80($section);}
		case " 40"	{$r = addsection_40($section);}
		case " 20"	{$r = addsection_20($section);}
		case " 15"	{$r = addsection_15($section);}
		case " 10"	{$r = addsection_10($section);}
		case "99"   {$r = addsection_all($section);
		}
	}
	return $r;
}

#################################################
sub checksection {
#################################################
	my ($section, $band) = @_;

	my $r = 0;

	switch($band) {
		case "160"	{$r = checksection_160($section);}
		case " 80"	{$r = checksection_80($section);}
		case " 40"	{$r = checksection_40($section);}
		case " 20"	{$r = checksection_20($section);}
		case " 15"	{$r = checksection_15($section);}
		case " 10"	{$r = checksection_10($section);}
		case "99"	{$r = checksection_all($section);}
	}
	if ($r) {
		return $r;
	} else {
		return 0;
	}
}

#################################################
sub delsection {
#################################################
	my ($section, $band) = @_;

	switch($band) {
		case 160	{$r = delsection_160($section)}
		case  80	{$r = delsection_80($section)}
		case  40	{$r = delsection_40($section)}
		case  20	{$r = delsection_20($section)}
		case  15	{$r = delsection_15($section)}
		case  10	{$r = delsection_10($section)}
	}
	return $r;
}


{ # start block#########################################

%section_all = ();
%section_10 = ();
%section_15 = ();
%section_20 = ();
%section_40 = ();
%section_80 = ();
%section_160 = ();

#################################################
sub addsection_all {
#################################################
	my $section = shift @_;
	
		$section_all{$section}++;
		return $section_all{$section};
	
}
#################################################
sub addsection_10 {
#################################################
	my $section = shift @_;
	
		$section_10{$section}++;
		return $section_10{$section};
	
}
#################################################
sub checksection_10 {
#################################################
	my $section = shift @_;
	if ($section_10{$section}) {
		return $section_10{$section};
	}
	return 0;
}

#################################################
sub delsection_10 {
#################################################
	my $section = shift @_;
	
	if ($section_10{$section}) {
		$section_10{$section}--; 
		$section_all{$section}--; 
		return $section_10{$section};
	}
	return 0;
}

#################################################
sub addsection_15 {
#################################################
	my $section = shift @_;
	
		$section_15{$section}++;
		return $section_15{$section};
	
}
#################################################
sub checksection_15 {
#################################################
	my $section = shift @_;
	if ($section_15{$section}) {
		return $section_15{$section};
	}
	return 0;
}

#################################################
sub delsection_15 {
#################################################
	my $section = shift @_;
	
	if ($section_15{$section}) {
		$section_15{$section}--; 
		$section_all{$section}--; 
		return $section_15{$section};
	}
	return 0;
}

#################################################
sub addsection_20 {
#################################################
	my $section = shift @_;
	
		$section_20{$section}++;

		return $section_20{$section};
	
}
#################################################
sub checksection_20 {
#################################################
	my $section = shift @_;
	if ($section_20{$section}) {
		return $section_20{$section};
	}
	return 0;
}

#################################################
sub delsection_20 {
#################################################
	my $section = shift @_;
	
	if ($section_20{$section}) {
		$section_20{$section}--; 
		$section_all{$section}--; 
		return $section_20{$section};
	}
	return 0;
}

#################################################
sub addsection_40 {
#################################################
	my $section = shift @_;

		$section_40{$section}++;

		return $section_40{$section};
	
}
#################################################
sub checksection_40 {
#################################################
	my $section = shift @_;
	if ($section_40{$section}) {
		return $section_40{$section};
	}
	return 0;
}

#################################################
sub delsection_40 {
#################################################
	my $section = shift @_;
	
	if ($section_40{$section}) {
		$section_40{$section}--; 
		$section_all{$section}--; 
		return $section_40{$section};
	}
	return 0;
}

#################################################
sub addsection_80 {
#################################################
	my $section = shift @_;
	
		$section_80{$section}++;
		return $section_80{$section};
	
}
#################################################
sub checksection_80 {
#################################################
	my $section = shift @_;
	if ($section_80{$section}) {
		return $section_80{$section};
	}
	return 0;
}

#################################################
sub delsection_80 {
#################################################
	my $section = shift @_;
	
	if ($section_80{$section}) {
		$section_80{$section}--; 
		$section_all{$section}--; 
		return $section_80{$section};
	}
	return 0;
}

#################################################
sub addsection_160 {
#################################################
	my $section = shift @_;
	
		$section_160{$section}++;
		return $section_160{$section};
	
}
#################################################
sub checksection_160 {
#################################################
	my $section = shift @_;
	if ($section_160{$section}) {
		return $section_160{$section};
	}
	return 0;
}

#################################################
sub delsection_160 {
#################################################
	my $section = shift @_;
	
	if ($section_160{$section}) {
		$section_160{$section}--; 
		$section_all{$section}--; 
		return $section_160{$section};
	}
	return 0;
}

#################################################
sub checksection_all {
#################################################
	my $section = shift @_;
	if ($section_all{$section}) {
		return $section_all{$section};
	}
	return 0;
}
#################################################
sub countsections_all {
#################################################
my $count = 0;
my @out = ();
	foreach my $key (keys %section_all) {
		$count ++;
	}
	push @out, $count;
	return @out;
}

#################################################
sub countsections {
#################################################
my $count = 0;
my @out = ();
	foreach my $key (keys %section_160) {
		$count ++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %section_80) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %section_40) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %section_20) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %section_15) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %section_10) {
		$count++;
	}
	push @out, $count;
	
	return @out;
}

###############################################
sub init_sections {
###############################################
%section_all = ();
%section_10 = ();
%section_15 = ();
%section_20 = ();
%section_40 = ();
%section_80 = ();
%section_160 = ();
}

} # end block ##########################################
	
{ # start block#########################################

my %cwsection_all;
my %cwsection_10;
my %cwsection_15;
my %cwsection_20;
my %cwsection_40;
my %cwection_80;
my %cwsection_160;

#################################################
sub addcwsection {
#################################################
	my ($section, $band) = @_;
	if ($section =~ /([A-Z]).*/) {
		; # continue
	} else { return 0; } # is serial nr.

	switch($band) {
		case 160	{
				$cwsection_160{$section}++;
				$r = $cwsection_160{$section};
			}
		case  80	{
				$cwsection_80{$section}++;
				$r = $cwsection_80{$section};
			}
		case  40	{
				$cwsection_40{$section}++;
				$r = $cwsection_40{$section};
			}
		case  20	{
				$cwsection_20{$section}++;
				$r = $cwsection_20{$section};
			}
		case  15	{
				$cwsection_15{$section}++;
				$r = $cwsection_15{$section};
			}
		case  10	{
				$cwsection_10{$section}++;
				$r = $cwsection_10{$section};
			}
		case  "all"	{
				$cwsection_all{$section}++;
				$r = $cwsection_all{$section};
			}
	}
	return $r;
}
#################################################
sub countcwsections {
#################################################
my $count = 0;
my @out = ();
	foreach my $key (keys %cwsection_160) {
		$count ++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %cwsection_80) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %cwsection_40) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %cwsection_20) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %cwsection_15) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %cwsection_10) {
		$count++;
	}
	push @out, $count;
	
	return @out;
}
#####################################
sub init_cwsections {
#####################################
 %cwsection_all = ();
 %cwsection_10 = ();
 %cwsection_15 = ();
 %cwsection_20 = ();
 %cwsection_40 = ();
 %cwection_80 = ();
 %cwsection_160 = ();
}

} # end block #########################################

{ # start block#########################################

my %ssbsection_all;
my %ssbsection_10;
my %ssbsection_15;
my %ssbsection_20;
my %ssbsection_40;
my %ssbection_80;
my %ssbsection_160;

#################################################
sub addssbsection {
#################################################
	my ($section, $band) = @_;

	if ($section =~ /([A-Z]).*/) {
		; # continue
	} else { return 0; } # is serial nr.

	switch($band) {
		case 160	{
				$ssbsection_160{$section}++;
				$r = $ssbsection_160{$section};
			}
		case  80	{
				$ssbsection_80{$section}++;
				$r = $ssbsection_80{$section};
			}
		case  40	{
				$ssbsection_40{$section}++;
				$r = $ssbsection_40{$section};
			}
		case  20	{
				$ssbsection_20{$section}++;
				$r = $ssbsection_20{$section};
			}
		case  15	{
				$ssbsection_15{$section}++;
				$r = $ssbsection_15{$section};
			}
		case  10	{
				$ssbsection_10{$section}++;
				$r = $ssbsection_10{$section};
			}
		case  "all"	{
				$ssbsection_all{$section}++;
				$r = $ssbsection_all{$section};
			}
	}
	return $r;
}
#################################################
sub countssbsections {
#################################################
my $count = 0;
my @out = ();
	foreach my $key (keys %ssbsection_160) {
		$count ++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %ssbsection_80) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %ssbsection_40) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %ssbsection_20) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %ssbsection_15) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %ssbsection_10) {
		$count++;
	}
	push @out, $count;
	
	return @out;
}
#######################################
sub init_ssbsections {
#######################################
 %ssbsection_all = ();
 %ssbsection_10 = ();
 %ssbsection_15 = ();
 %ssbsection_20 = ();
 %ssbsection_40 = ();
 %ssbection_80 = ();
 %ssbsection_160 = ();
}


} # end block #########################################


#################################################
sub testsections {
#################################################

	while (1) {
		print "\nEnter section:";
		my $section = <STDIN>;
		chomp $section;
		if ($section eq "q") {
			exit;
		} else {
			if (section_valid ($section, %valid_sections)) {
				print "$section is o.k.!\n";
			} else {
				print "Not found!\n";
			}
		}
	}
}
} # end outer block
1;

