#! /usr/bin/perl -w


# Ham Radio FOC Marathon scoring module foc.pm by DJ1YFK

# This program is published under the GPL license.
#   Copyright (C) 2006
#       Rein Couperus PA0R (rein@couperus.com)
# 
# *    iota.pm is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    iota.pm is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Date: 15-04-06

use rules;

my $fiver=0;
my $sixer=0;
my $dxcc=0;
my $continents=0;
my %callhash;
my $dxcchash;
my $continenthash;

sub focaddqso {								# count up one, for 5/6-banders
	if (defined($callhash{$_[0]})) {
	$callhash{$call}++;
}
else { $callhash{$call}=1; }
}

sub focfiver {								# 5-bander == 10 points
	$call = shift;
	if (defined($callhash{$call}) && $callhash{$call}==5) {
		$fiver++;
		return 1;
	}
	else { return 0; }
}

sub focsixer {								# 6-bander == 5 points
	$call = shift;
	if (defined($callhash{$call}) && $callhash{$call}==6) {
		$sixer++;
	return 1;
	}
	else { return 0; }
}

sub focdxcc {								# DXCC (over all bands) == 2 points
	my $ret=0;
	unless (defined($dxcchash{$_[0]})) {
		$dxcchash{$_[0]}=1;
		$dxcc++;
		$ret = 2;
	}
	unless (defined($continenthash{$_[1]})) {	# continent == 5 points	
		$continenthash{$_[1]}=1;
		$continents++;
		$ret += 5;
	}
	return $ret;
}


sub get_focpoints {         # additional points
	return (($fiver*10)+($sixer*5)+($dxcc*2)+($continents*5));
}

sub get_focinfo {           # Info-line
	return "Fiver: $fiver  Sixer: $sixer  DXCC: $dxcc  Cont: $continents\n";
}



1;
