/*  
   xmms-sid - SIDPlay input plugin for X MultiMedia System (XMMS)

   Configuration dialog
   
   Written by Matti "ccr" Hamalainen <mhamalai@ratol.fi>
   (Interface created with Glade, the Gtk+ interface builder,
   code edited by hand afterwards to make it work here)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include "xmms-sid.h"
#include <xmms/configfile.h>
#include <gtk/gtk.h>
#include <stdio.h>


/*
 * General stuff
 */
static GtkWidget *xs_configwin = NULL;
static GtkWidget *xs_fileselector = NULL;

static GtkObject *cfg_samplerate_adj, *cfg_filt_fm_adj, *cfg_filt_ft_adj, *cfg_filt_fs_adj;
static GtkWidget *cfg_res_8bit, *cfg_res_16bit, *cfg_checkfilecontent, *cfg_chn_mono;
static GtkWidget *cfg_chn_stereo, *cfg_chn_autopan, *cfg_mem_banksw, *cfg_mem_transrom, *cfg_mem_playsid;
static GtkWidget *cfg_songnameformat, *cfg_clock_pal, *cfg_clock_ntsc, *cfg_clock_force, *cfg_ok, *cfg_cancel;
static GtkWidget *cfg_wav_mos6581, *cfg_wav_mos8580, *cfg_emufilters, *cfg_stil_browse, *cfg_stil_use, *cfg_stil_path;



/*
 * Configuration specific stuff
 */
#define XS_CFGTABLE_MAX	15

T_sid_cfg_entry xs_cfgtable[XS_CFGTABLE_MAX] = {
	{ ATYPE_INT,	&xs_cfg.bitsPerSample,	"bitsPerSample",},
	{ ATYPE_INT,	&xs_cfg.channels,	"channels"	},
	{ ATYPE_INT,	&xs_cfg.frequency,	"frequency"	},
	{ ATYPE_BOOL,	&xs_cfg.mos8580,	"mos8580",	},
	{ ATYPE_BOOL,	&xs_cfg.emulateFilter,	"emulateFilter"	},
	{ ATYPE_FLOAT,	&xs_cfg.filterFs,	"filterFs"	},
	{ ATYPE_FLOAT,	&xs_cfg.filterFm,	"filterFm"	},
	{ ATYPE_FLOAT,	&xs_cfg.filterFt,	"filterFt"	},
	{ ATYPE_INT,	&xs_cfg.memoryMode,	"memoryMode"	},
	{ ATYPE_INT,	&xs_cfg.clockSpeed,	"clockSpeed"	},
	{ ATYPE_BOOL,	&xs_cfg.forceSpeed,	"forceSpeed"	},
	{ ATYPE_BOOL,	&xs_cfg.detectMagic,	"detectMagic"	},
	{ ATYPE_STR,	&xs_cfg.stilpath,	"STILpath"	},
	{ ATYPE_BOOL,	&xs_cfg.usestil,	"useSTIL"	},
	{ ATYPE_STR,	&xs_cfg.fileInfo,	"fileInfo"	}
};



/*
 * Get the configuration (from file or default)
 */
void xs_cfg_filter_reset(void)
{
	/* Reset filter values */
	xs_cfg.filterFs = XMMS_SID_DEFAULT_FILTERFS;
	xs_cfg.filterFm = XMMS_SID_DEFAULT_FILTERFM;
	xs_cfg.filterFt = XMMS_SID_DEFAULT_FILTERFT;
}


void xs_get_configure(void)
{
	gchar *cfg_fn, *tmpstr;
	ConfigFile *cfg_file;
	gint i;
	
	/* Pre-initialize configuration structure */
	xs_cfg.bitsPerSample	= 16;
	xs_cfg.channels		= XMMS_SID_CHN_MONO;
	xs_cfg.frequency	= 44100;
	xs_cfg.mos8580		= FALSE;
	xs_cfg.emulateFilter	= TRUE;
	xs_cfg.memoryMode	= XMMS_SID_MPU_BANK_SWITCHING;
	xs_cfg.clockSpeed	= XMMS_SID_CLOCK_PAL;
	xs_cfg.forceSpeed	= FALSE;
	xs_cfg.detectMagic	= FALSE;
	xs_strcalloc(&xs_cfg.stilpath, "~/C64Music/DOCUMENTS/STIL.txt");
	xs_cfg.usestil		= FALSE;
	xs_strcalloc(&xs_cfg.fileInfo, "%1 - %2");

	xs_cfg_filter_reset();

	
	/* Try to open the XMMS configuration file */
	cfg_fn = g_strconcat(g_get_home_dir(), "/.xmms/config", NULL);
	cfg_file = xmms_cfg_open_file(cfg_fn);
	g_free(cfg_fn);
	if (cfg_file == 0) return;

	/* Read the new settings from XMMS configuration file */
	
	/* WARNING: Some "goto magic" coming up! */

	for (i = 0; i < XS_CFGTABLE_MAX; i++) {
	
		switch (xs_cfgtable[i].atype) {
		case ATYPE_INT:		if (!xmms_cfg_read_int(cfg_file, XMMS_SID_CONFIG_IDENT,
					xs_cfgtable[i].aname, (gint *) xs_cfgtable[i].adata)) goto rexit;
					break;
										
		case ATYPE_BOOL:	if (!xmms_cfg_read_boolean(cfg_file, XMMS_SID_CONFIG_IDENT,
					xs_cfgtable[i].aname, (gboolean *) xs_cfgtable[i].adata)) goto rexit;
					break;
					
		case ATYPE_FLOAT:	if (!xmms_cfg_read_float(cfg_file, XMMS_SID_CONFIG_IDENT,
					xs_cfgtable[i].aname, (gfloat *) xs_cfgtable[i].adata)) goto rexit;
					break;
					
		case ATYPE_STR:		if (!xmms_cfg_read_string(cfg_file, XMMS_SID_CONFIG_IDENT,
						xs_cfgtable[i].aname, &tmpstr)) goto rexit;

					/* Read was successfull */
					xs_strcalloc((gchar **) xs_cfgtable[i].adata, tmpstr);

					g_free(tmpstr);
					
					break;

		default:		XSERR("Internal: Unsupported setting type found while reading configuration file. Please report to author!\n");
					break;
		}

		}

rexit:
	/* Free the config file */
	xmms_cfg_free(cfg_file);
}


/*
 * Configuration panel was canceled
 */
void xs_configure_cancel(void)
{
	gtk_widget_destroy(xs_configwin);
}


/*
 * Configuration was accepted (OK), save the settings
 */
void xs_configure_ok(void)
{
	ConfigFile *cfg_file;
	gchar *cfg_fn;
	gint i;
	
	/* Check the resolution settings */	
	if (GTK_TOGGLE_BUTTON(cfg_res_16bit)->active)
		xs_cfg.bitsPerSample = 16;
	else if (GTK_TOGGLE_BUTTON(cfg_res_8bit)->active)
		xs_cfg.bitsPerSample = 8;

	if (GTK_TOGGLE_BUTTON(cfg_chn_mono)->active)
		xs_cfg.channels = XMMS_SID_CHN_MONO;
	else if (GTK_TOGGLE_BUTTON(cfg_chn_stereo)->active)
		xs_cfg.channels = XMMS_SID_CHN_STEREO;
	else if (GTK_TOGGLE_BUTTON(cfg_chn_autopan)->active)
		xs_cfg.channels = XMMS_SID_CHN_AUTOPAN;
	
	xs_cfg.frequency = (gint)GTK_ADJUSTMENT(cfg_samplerate_adj)->value;
	

	/* Memorymode settings */
	if (GTK_TOGGLE_BUTTON(cfg_mem_banksw)->active)
		xs_cfg.memoryMode = XMMS_SID_MPU_BANK_SWITCHING;
	else if (GTK_TOGGLE_BUTTON(cfg_mem_transrom)->active)
		xs_cfg.memoryMode = XMMS_SID_MPU_TRANSPARENT_ROM;
	else if (GTK_TOGGLE_BUTTON(cfg_mem_playsid)->active)
		xs_cfg.memoryMode = XMMS_SID_MPU_PLAYSID_ENVIRONMENT;

	
	/* Clockspeed settings */
	if (GTK_TOGGLE_BUTTON(cfg_clock_pal)->active)
		xs_cfg.clockSpeed = XMMS_SID_CLOCK_PAL;
	else if (GTK_TOGGLE_BUTTON(cfg_clock_ntsc)->active)
		xs_cfg.clockSpeed = XMMS_SID_CLOCK_NTSC;

	xs_cfg.forceSpeed = GTK_TOGGLE_BUTTON(cfg_clock_force)->active;


	/* Filter and waveform settings */
	xs_cfg.mos8580 = ((GTK_TOGGLE_BUTTON(cfg_wav_mos8580)->active) && (!GTK_TOGGLE_BUTTON(cfg_wav_mos6581)->active));
		
	xs_cfg.emulateFilter = GTK_TOGGLE_BUTTON(cfg_emufilters)->active;
	xs_cfg.filterFs = GTK_ADJUSTMENT(cfg_filt_fs_adj)->value;
	xs_cfg.filterFm = GTK_ADJUSTMENT(cfg_filt_fm_adj)->value;
	xs_cfg.filterFt = GTK_ADJUSTMENT(cfg_filt_ft_adj)->value;
	

	/* STIL and miscellaneous settings */	
	xs_cfg.detectMagic = GTK_TOGGLE_BUTTON(cfg_checkfilecontent)->active;
	xs_cfg.usestil = GTK_TOGGLE_BUTTON(cfg_stil_use)->active;
	if (xs_cfg.stilpath != NULL) g_free(xs_cfg.stilpath);
	xs_cfg.stilpath = gtk_entry_get_text(GTK_ENTRY(cfg_stil_path)); 
	if (xs_cfg.fileInfo != NULL) g_free(xs_cfg.fileInfo);
	xs_cfg.fileInfo = gtk_entry_get_text(GTK_ENTRY(cfg_songnameformat)); 
		

	/* Try to open the XMMS configuration file */
	cfg_fn = g_strconcat(g_get_home_dir(),"/.xmms/config",NULL);
	cfg_file = xmms_cfg_open_file(cfg_fn);
	if (!cfg_file) cfg_file = xmms_cfg_new();


	/* Write the new settings to XMMS configuration file */
	for (i = 0; i < XS_CFGTABLE_MAX; i++) {

		switch (xs_cfgtable[i].atype) {
		case ATYPE_INT:		xmms_cfg_write_int(cfg_file, XMMS_SID_CONFIG_IDENT,
					xs_cfgtable[i].aname, * (gint *) xs_cfgtable[i].adata);
					break;
					
		case ATYPE_BOOL:	xmms_cfg_write_boolean(cfg_file, XMMS_SID_CONFIG_IDENT,
					xs_cfgtable[i].aname, * (gboolean *) xs_cfgtable[i].adata);
					break;

		case ATYPE_FLOAT:	xmms_cfg_write_float(cfg_file, XMMS_SID_CONFIG_IDENT,
					xs_cfgtable[i].aname, * (gfloat *) xs_cfgtable[i].adata);
					break;

		case ATYPE_STR:		xmms_cfg_write_string(cfg_file, XMMS_SID_CONFIG_IDENT,
					xs_cfgtable[i].aname, * (gchar **) xs_cfgtable[i].adata);
					break;

		default:	XSERR("Internal: Unsupported setting type found while writing configuration file. Please report to author!\n");
				break;
		}
		
		}		

	xmms_cfg_write_file(cfg_file, cfg_fn);

	xmms_cfg_free(cfg_file);

	g_free(cfg_fn);

	gtk_widget_destroy(xs_configwin);
}


/*
 * Update filter setting sliders
 */
static void xs_cfg_filt_update(void)
{
	gtk_adjustment_set_value(GTK_ADJUSTMENT(cfg_filt_fs_adj), xs_cfg.filterFs);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(cfg_filt_fm_adj), xs_cfg.filterFm);
	gtk_adjustment_set_value(GTK_ADJUSTMENT(cfg_filt_ft_adj), xs_cfg.filterFt);
}


/*
 * Reset filter settings to defaults
 */
static void xs_cfg_filt_reset(void)
{
	xs_cfg_filter_reset();
	xs_cfg_filt_update();
}


/*
 * STIL-database file selector response-functions
 */
void xs_cfg_fs_ok(void)
{
	/* Selection was accepted! */
	gtk_entry_set_text(
		GTK_ENTRY(cfg_stil_path), 
		gtk_file_selection_get_filename(GTK_FILE_SELECTION (xs_fileselector))
		);

	/* Close file selector window */
	gtk_widget_destroy(xs_fileselector);
	xs_fileselector = NULL;
}


void xs_cfg_fs_cancel(void)
{
	/* Close file selector window */
	gtk_widget_destroy(xs_fileselector);
	xs_fileselector = NULL;
}


/*
 * Open up a file-selection dialog for browsing STIL-database file
 */
void xs_cfg_stil_browse(void)
{
  GtkWidget *fs_but_ok, *fs_but_cancel;

  /* Check if the window already exists */
  if (xs_fileselector != NULL) {
	gdk_window_raise(xs_fileselector->window);
	return;
	}

  /* No, create a new one */
  xs_fileselector = gtk_file_selection_new ("Select STIL Database-File");
  gtk_signal_connect(GTK_OBJECT(xs_fileselector),"destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed),&xs_fileselector);

  gtk_object_set_data (GTK_OBJECT (xs_fileselector), "xs_fileselector", xs_fileselector);
  gtk_container_set_border_width (GTK_CONTAINER (xs_fileselector), 10);
  GTK_WINDOW (xs_fileselector)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_position (GTK_WINDOW (xs_fileselector), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (xs_fileselector), TRUE);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (xs_fileselector));

  fs_but_ok = GTK_FILE_SELECTION (xs_fileselector)->ok_button;
  gtk_object_set_data (GTK_OBJECT (xs_fileselector), "fs_but_ok", fs_but_ok);
  gtk_widget_show (fs_but_ok);
  GTK_WIDGET_SET_FLAGS (fs_but_ok, GTK_CAN_DEFAULT);

  fs_but_cancel = GTK_FILE_SELECTION (xs_fileselector)->cancel_button;
  gtk_object_set_data (GTK_OBJECT (xs_fileselector), "fs_but_cancel", fs_but_cancel);
  gtk_widget_show (fs_but_cancel);
  GTK_WIDGET_SET_FLAGS (fs_but_cancel, GTK_CAN_DEFAULT);


  /* Connect signals */
  gtk_signal_connect (GTK_OBJECT (fs_but_ok), "clicked",
                      GTK_SIGNAL_FUNC (xs_cfg_fs_ok),
                      NULL);

  gtk_signal_connect (GTK_OBJECT (fs_but_cancel), "clicked",
                      GTK_SIGNAL_FUNC (xs_cfg_fs_cancel),
                      NULL);

  /* Show the dialog */
  gtk_widget_show(xs_fileselector);
}


/*
 * Execute the configuration panel
 */
void xs_configure(void)
{
  GSList *resolution_group = NULL;
  GSList *channels_group = NULL;
  GSList *speed_group = NULL;
  GSList *waveforms_group = NULL;
  GSList *memorymode_group = NULL;
  GtkWidget *vbox1, *cfg_notebook, *vbox6, *hbox2, *frame4, *vbox9, *frame5, *vbox10;
  GtkWidget *frame8, *alignment4, *hbox4, *label8, *label1, *vbox2, *hbox1, *frame2, *vbox4, *frame3;
  GtkWidget *vbox3, *frame1, *vbox5, *label2, *vbox7, *frame7, *vbox8, *hbox3, *label4, *alignment2;
  GtkWidget *alignment1, *frame9, *vbox11, *alignment3, *label7, *label3, *fixed1,*label9, *frame12;
  GtkWidget *cfg_frm2, *cfg_frm1, *label6, *hbuttonbox1;
  GtkWidget *cfg_filt_reset, *cfg_samplerate, *cfg_filt_fm,*cfg_filt_fs, *cfg_filt_ft;
  GtkTooltips *tooltips;

  /* Check if the window already exists */
  if (xs_configwin != NULL) {
	gdk_window_raise(xs_configwin->window);
	return;
	}


  /* No, create a new one */
  tooltips = gtk_tooltips_new ();

  xs_configwin = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_signal_connect(GTK_OBJECT(xs_configwin),"destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed),&xs_configwin);
  gtk_object_set_data (GTK_OBJECT (xs_configwin), "xs_configwin", xs_configwin);
  gtk_window_set_title (GTK_WINDOW (xs_configwin), "xmms-sid configuration");
  gtk_window_set_policy (GTK_WINDOW (xs_configwin), FALSE, FALSE, FALSE);
  gtk_window_set_position (GTK_WINDOW(xs_configwin), GTK_WIN_POS_MOUSE);
  
  /* Start creating the widgets ! */
  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (xs_configwin), vbox1);
  gtk_container_set_border_width (GTK_CONTAINER (vbox1), 8);

  cfg_notebook = gtk_notebook_new ();
  gtk_widget_ref (cfg_notebook);
  gtk_widget_show (cfg_notebook);
  gtk_box_pack_start (GTK_BOX (vbox1), cfg_notebook, TRUE, TRUE, 0);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox6);
  gtk_widget_show (vbox6);
  gtk_container_add (GTK_CONTAINER (cfg_notebook), vbox6);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox6), hbox2, TRUE, TRUE, 0);

  frame4 = gtk_frame_new ("Resolution:");
  gtk_widget_ref (frame4);
  gtk_widget_show (frame4);
  gtk_box_pack_start (GTK_BOX (hbox2), frame4, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame4), 4);

  vbox9 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox9);
  gtk_widget_show (vbox9);
  gtk_container_add (GTK_CONTAINER (frame4), vbox9);

  cfg_res_8bit = gtk_radio_button_new_with_label (resolution_group, "8-bit");
  resolution_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cfg_res_8bit));
  gtk_widget_ref (cfg_res_8bit);
  gtk_widget_show (cfg_res_8bit);
  gtk_box_pack_start (GTK_BOX (vbox9), cfg_res_8bit, FALSE, FALSE, 0);

  cfg_res_16bit = gtk_radio_button_new_with_label (resolution_group, "16-bit");
  resolution_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cfg_res_16bit));
  gtk_widget_ref (cfg_res_16bit);
  gtk_widget_show (cfg_res_16bit);
  gtk_box_pack_start (GTK_BOX (vbox9), cfg_res_16bit, FALSE, FALSE, 0);

  frame5 = gtk_frame_new ("Channels:");
  gtk_widget_ref (frame5);
  gtk_widget_show (frame5);
  gtk_box_pack_start (GTK_BOX (hbox2), frame5, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame5), 4);

  vbox10 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox10);
  gtk_widget_show (vbox10);
  gtk_container_add (GTK_CONTAINER (frame5), vbox10);

  cfg_chn_mono = gtk_radio_button_new_with_label (channels_group, "Mono");
  channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cfg_chn_mono));
  gtk_widget_ref (cfg_chn_mono);
  gtk_widget_show (cfg_chn_mono);
  gtk_box_pack_start (GTK_BOX (vbox10), cfg_chn_mono, FALSE, FALSE, 0);

  cfg_chn_stereo = gtk_radio_button_new_with_label (channels_group, "Stereo");
  channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cfg_chn_stereo));
  gtk_widget_ref (cfg_chn_stereo);
  gtk_widget_show (cfg_chn_stereo);
  gtk_box_pack_start (GTK_BOX (vbox10), cfg_chn_stereo, FALSE, FALSE, 0);

  cfg_chn_autopan = gtk_radio_button_new_with_label (channels_group, "Autopanning");
  channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cfg_chn_autopan));
  gtk_widget_ref (cfg_chn_autopan);
  gtk_widget_show (cfg_chn_autopan);
  gtk_box_pack_start (GTK_BOX (vbox10), cfg_chn_autopan, FALSE, FALSE, 0);

  frame8 = gtk_frame_new ("Samplerate:");
  gtk_widget_ref (frame8);
  gtk_widget_show (frame8);
  gtk_box_pack_start (GTK_BOX (vbox6), frame8, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame8), 4);

  alignment4 = gtk_alignment_new (0.04, 0, 0.12, 0.5);
  gtk_widget_ref (alignment4);
  gtk_widget_show (alignment4);
  gtk_container_add (GTK_CONTAINER (frame8), alignment4);

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox4);
  gtk_widget_show (hbox4);
  gtk_container_add (GTK_CONTAINER (alignment4), hbox4);

  cfg_samplerate_adj = gtk_adjustment_new (44100, 4000, 48000, 100, 1000, 0);
  cfg_samplerate = gtk_spin_button_new (GTK_ADJUSTMENT (cfg_samplerate_adj), 1, 0);
  gtk_widget_ref (cfg_samplerate);
  gtk_widget_show (cfg_samplerate);
  gtk_box_pack_start (GTK_BOX (hbox4), cfg_samplerate, TRUE, TRUE, 0);

  label8 = gtk_label_new ("Hz");
  gtk_widget_ref (label8);
  gtk_widget_show (label8);
  gtk_box_pack_start (GTK_BOX (hbox4), label8, FALSE, TRUE, 4);

  cfg_checkfilecontent = gtk_check_button_new_with_label ("Determine filetype by contents (slower)");
  gtk_widget_ref (cfg_checkfilecontent);
  gtk_widget_show (cfg_checkfilecontent);
  gtk_box_pack_start (GTK_BOX (vbox6), cfg_checkfilecontent, FALSE, FALSE, 0);

  label1 = gtk_label_new ("Audio");
  gtk_widget_ref (label1);
  gtk_widget_show (label1);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (cfg_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (cfg_notebook), 0), label1);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox2);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (cfg_notebook), vbox2);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox1, TRUE, TRUE, 0);

  frame2 = gtk_frame_new ("Clock Speed:");
  gtk_widget_ref (frame2);
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (hbox1), frame2, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 4);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox4);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (frame2), vbox4);

  cfg_clock_pal = gtk_radio_button_new_with_label (speed_group, "PAL");
  speed_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cfg_clock_pal));
  gtk_widget_ref (cfg_clock_pal);
  gtk_widget_show (cfg_clock_pal);
  gtk_box_pack_start (GTK_BOX (vbox4), cfg_clock_pal, FALSE, FALSE, 0);

  cfg_clock_ntsc = gtk_radio_button_new_with_label (speed_group, "NTSC");
  speed_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cfg_clock_ntsc));
  gtk_widget_ref (cfg_clock_ntsc);
  gtk_widget_show (cfg_clock_ntsc);
  gtk_box_pack_start (GTK_BOX (vbox4), cfg_clock_ntsc, FALSE, FALSE, 0);

  cfg_clock_force = gtk_check_button_new_with_label ("Force speed");
  gtk_widget_ref (cfg_clock_force);
  gtk_widget_show (cfg_clock_force);
  gtk_box_pack_start (GTK_BOX (vbox4), cfg_clock_force, FALSE, FALSE, 0);

  frame3 = gtk_frame_new ("Waveforms:");
  gtk_widget_ref (frame3);
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (hbox1), frame3, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame3), 4);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox3);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (frame3), vbox3);

  cfg_wav_mos6581 = gtk_radio_button_new_with_label (waveforms_group, "MOS 6581");
  waveforms_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cfg_wav_mos6581));
  gtk_widget_ref (cfg_wav_mos6581);
  gtk_widget_show (cfg_wav_mos6581);
  gtk_box_pack_start (GTK_BOX (vbox3), cfg_wav_mos6581, FALSE, FALSE, 0);

  cfg_wav_mos8580 = gtk_radio_button_new_with_label (waveforms_group, "MOS 8580");
  waveforms_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cfg_wav_mos8580));
  gtk_widget_ref (cfg_wav_mos8580);
  gtk_widget_show (cfg_wav_mos8580);
  gtk_box_pack_start (GTK_BOX (vbox3), cfg_wav_mos8580, FALSE, FALSE, 0);

  cfg_emufilters = gtk_check_button_new_with_label ("Emulate filters");
  gtk_widget_ref (cfg_emufilters);
  gtk_widget_show (cfg_emufilters);
  gtk_box_pack_start (GTK_BOX (vbox3), cfg_emufilters, FALSE, FALSE, 0);

  frame1 = gtk_frame_new ("Memory Mode:");
  gtk_widget_ref (frame1);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox2), frame1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 4);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox5);
  gtk_widget_show (vbox5);
  gtk_container_add (GTK_CONTAINER (frame1), vbox5);

  cfg_mem_banksw = gtk_radio_button_new_with_label (memorymode_group, "Bank switching");
  memorymode_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cfg_mem_banksw));
  gtk_widget_ref (cfg_mem_banksw);
  gtk_widget_show (cfg_mem_banksw);
  gtk_box_pack_start (GTK_BOX (vbox5), cfg_mem_banksw, FALSE, FALSE, 0);

  cfg_mem_transrom = gtk_radio_button_new_with_label (memorymode_group, "Transparent ROM");
  memorymode_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cfg_mem_transrom));
  gtk_widget_ref (cfg_mem_transrom);
  gtk_widget_show (cfg_mem_transrom);
  gtk_box_pack_start (GTK_BOX (vbox5), cfg_mem_transrom, FALSE, FALSE, 0);

  cfg_mem_playsid = gtk_radio_button_new_with_label (memorymode_group, "PlaySID environment");
  memorymode_group = gtk_radio_button_group (GTK_RADIO_BUTTON (cfg_mem_playsid));
  gtk_widget_ref (cfg_mem_playsid);
  gtk_widget_show (cfg_mem_playsid);
  gtk_box_pack_start (GTK_BOX (vbox5), cfg_mem_playsid, FALSE, FALSE, 0);

  label2 = gtk_label_new ("Emulation");
  gtk_widget_ref (label2);
  gtk_widget_show (label2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (cfg_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (cfg_notebook), 1), label2);

  vbox7 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox7);
  gtk_widget_show (vbox7);
  gtk_container_add (GTK_CONTAINER (cfg_notebook), vbox7);

  frame7 = gtk_frame_new ("STIL Configuration:");
  gtk_widget_ref (frame7);
  gtk_widget_show (frame7);
  gtk_box_pack_start (GTK_BOX (vbox7), frame7, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame7), 4);

  vbox8 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox8);
  gtk_widget_show (vbox8);
  gtk_container_add (GTK_CONTAINER (frame7), vbox8);

  cfg_stil_use = gtk_check_button_new_with_label ("Use STIL information database");
  gtk_widget_ref (cfg_stil_use);
  gtk_widget_show (cfg_stil_use);
  gtk_box_pack_start (GTK_BOX (vbox8), cfg_stil_use, TRUE, FALSE, 0);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox3);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox3, TRUE, TRUE, 0);

  label4 = gtk_label_new ("STIL path:");
  gtk_widget_ref (label4);
  gtk_widget_show (label4);
  gtk_box_pack_start (GTK_BOX (hbox3), label4, FALSE, FALSE, 0);
  gtk_misc_set_padding (GTK_MISC (label4), 4, 0);

  alignment2 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_ref (alignment2);
  gtk_widget_show (alignment2);
  gtk_box_pack_start (GTK_BOX (hbox3), alignment2, TRUE, TRUE, 4);

  cfg_stil_path = gtk_entry_new ();
  gtk_widget_ref (cfg_stil_path);
  gtk_widget_show (cfg_stil_path);
  gtk_container_add (GTK_CONTAINER (alignment2), cfg_stil_path);

  alignment1 = gtk_alignment_new (0.5, 0.5, 1, 0.300001);
  gtk_widget_ref (alignment1);
  gtk_widget_show (alignment1);
  gtk_box_pack_end (GTK_BOX (hbox3), alignment1, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (alignment1), 4);

  cfg_stil_browse = gtk_button_new_with_label ("Browse");
  gtk_widget_ref (cfg_stil_browse);
  gtk_widget_show (cfg_stil_browse);
  gtk_container_add (GTK_CONTAINER (alignment1), cfg_stil_browse);

  frame9 = gtk_frame_new ("Songname (Fileinfo) format:");
  gtk_widget_ref (frame9);
  gtk_widget_show (frame9);
  gtk_box_pack_start (GTK_BOX (vbox7), frame9, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame9), 4);

  vbox11 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox11);
  gtk_widget_show (vbox11);
  gtk_container_add (GTK_CONTAINER (frame9), vbox11);

  alignment3 = gtk_alignment_new (0.5, 0.5, 0.96, 1);
  gtk_widget_ref (alignment3);
  gtk_widget_show (alignment3);
  gtk_box_pack_start (GTK_BOX (vbox11), alignment3, FALSE, FALSE, 0);

  cfg_songnameformat = gtk_entry_new ();
  gtk_widget_ref (cfg_songnameformat);
  gtk_widget_show (cfg_songnameformat);
  gtk_container_add (GTK_CONTAINER (alignment3), cfg_songnameformat);

  label7 = gtk_label_new (
  "%1 - Composer\n"
  "%2 - Song name (title)\n"
  "%3 - Copyright\n"
  "%4 - SID-file type");
  gtk_widget_ref (label7);
  gtk_widget_show (label7);
  gtk_box_pack_start (GTK_BOX (vbox11), label7, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label7), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label7), 0.04, 0.5);

  label3 = gtk_label_new ("STIL");
  gtk_widget_ref (label3);
  gtk_widget_show (label3);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (cfg_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (cfg_notebook), 2), label3);

  fixed1 = gtk_fixed_new ();
  gtk_widget_ref (fixed1);
  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (cfg_notebook), fixed1);
  gtk_tooltips_set_tip (tooltips, fixed1, "Reset filter to default values", NULL);

  cfg_filt_reset = gtk_button_new_with_label ("Reset values");
  gtk_widget_ref (cfg_filt_reset);
  gtk_widget_show (cfg_filt_reset);
  gtk_fixed_put (GTK_FIXED (fixed1), cfg_filt_reset, 224, 16);
  gtk_widget_set_uposition (cfg_filt_reset, 224, 16);
  gtk_widget_set_usize (cfg_filt_reset, 120, 32);

  label9 = gtk_label_new (
  "These sliders affect the emulated SID's filter values.\n"
  "Defaults are what the libsidplay sets them on init.");
  gtk_widget_ref (label9);
  gtk_widget_show (label9);
  gtk_fixed_put (GTK_FIXED (fixed1), label9, 224, 56);
  gtk_widget_set_uposition (label9, 224, 56);
  gtk_widget_set_usize (label9, 136, 104);
  gtk_label_set_justify (GTK_LABEL (label9), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (label9), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label9), 0.5, 7.45058e-09);

  frame12 = gtk_frame_new ("FT");
  gtk_widget_ref (frame12);
  gtk_widget_show (frame12);
  gtk_fixed_put (GTK_FIXED (fixed1), frame12, 160, 16);
  gtk_widget_set_uposition (frame12, 160, 16);
  gtk_widget_set_usize (frame12, 48, 152);

  cfg_filt_ft_adj = gtk_adjustment_new (0, 0, 1, 0.01, 0.1, 0);
  cfg_filt_ft = gtk_vscale_new (GTK_ADJUSTMENT (cfg_filt_ft_adj));
  gtk_widget_ref (cfg_filt_ft);
  gtk_widget_show (cfg_filt_ft);
  gtk_container_add (GTK_CONTAINER (frame12), cfg_filt_ft);
  gtk_scale_set_digits (GTK_SCALE (cfg_filt_ft), 2);

  cfg_frm2 = gtk_frame_new ("FM");
  gtk_widget_ref (cfg_frm2);
  gtk_widget_show (cfg_frm2);
  gtk_fixed_put (GTK_FIXED (fixed1), cfg_frm2, 88, 16);
  gtk_widget_set_uposition (cfg_frm2, 88, 16);
  gtk_widget_set_usize (cfg_frm2, 48, 152);

  cfg_filt_fm_adj = gtk_adjustment_new (0, 0, 100, 1, 10, 0);
  cfg_filt_fm = gtk_vscale_new (GTK_ADJUSTMENT (cfg_filt_fm_adj));
  gtk_widget_ref (cfg_filt_fm);
  gtk_widget_show (cfg_filt_fm);
  gtk_container_add (GTK_CONTAINER (cfg_frm2), cfg_filt_fm);

  cfg_frm1 = gtk_frame_new ("FS");
  gtk_widget_ref (cfg_frm1);
  gtk_widget_show (cfg_frm1);
  gtk_fixed_put (GTK_FIXED (fixed1), cfg_frm1, 16, 16);
  gtk_widget_set_uposition (cfg_frm1, 16, 16);
  gtk_widget_set_usize (cfg_frm1, 56, 152);

  cfg_filt_fs_adj = gtk_adjustment_new (0, 0, 1000, 1, 100, 0);
  cfg_filt_fs = gtk_vscale_new (GTK_ADJUSTMENT (cfg_filt_fs_adj));
  gtk_widget_ref (cfg_filt_fs);
  gtk_widget_show (cfg_filt_fs);
  gtk_container_add (GTK_CONTAINER (cfg_frm1), cfg_filt_fs);

  label6 = gtk_label_new ("Filters");
  gtk_widget_ref (label6);
  gtk_widget_show (label6);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (cfg_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (cfg_notebook), 3), label6);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_ref (hbuttonbox1);
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_end (GTK_BOX (vbox1), hbuttonbox1, FALSE, FALSE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox1), GTK_BUTTONBOX_END);
  gtk_button_box_set_child_size (GTK_BUTTON_BOX (hbuttonbox1), 85, 30);

  cfg_ok = gtk_button_new_with_label ("OK");
  gtk_widget_ref (cfg_ok);
  gtk_widget_show (cfg_ok);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), cfg_ok);
  GTK_WIDGET_SET_FLAGS (cfg_ok, GTK_CAN_DEFAULT);
  gtk_tooltips_set_tip (tooltips, cfg_ok, "Accept and update changes", NULL);

  cfg_cancel = gtk_button_new_with_label ("Cancel");
  gtk_widget_ref (cfg_cancel);
  gtk_widget_show (cfg_cancel);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), cfg_cancel);
  GTK_WIDGET_SET_FLAGS (cfg_cancel, GTK_CAN_DEFAULT);
  gtk_tooltips_set_tip (tooltips, cfg_cancel, "Cancel any changes", NULL);


	/* Set the states of widgets */

	/* Sound resolution settings */
	switch (xs_cfg.bitsPerSample) {
	case 16:	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cfg_res_16bit), TRUE); break;
	case 8:		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cfg_res_8bit), TRUE); break;
	}

	gtk_adjustment_set_value(GTK_ADJUSTMENT(cfg_samplerate_adj), xs_cfg.frequency);
	
	/* Channel settings */
	switch (xs_cfg.channels) {
	case 0:	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cfg_chn_mono), TRUE); break;
	case 1:	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cfg_chn_stereo), TRUE); break;
	case 2:	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cfg_chn_autopan), TRUE); break;
	}
	
	/* Memorymode settings */
	switch (xs_cfg.memoryMode) {
	case XMMS_SID_MPU_BANK_SWITCHING:
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cfg_mem_banksw), TRUE);
		break;
		
	case XMMS_SID_MPU_TRANSPARENT_ROM:
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cfg_mem_transrom), TRUE);
		break;
	
	case XMMS_SID_MPU_PLAYSID_ENVIRONMENT:
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cfg_mem_playsid), TRUE);
		break;
	}


	/* Filter and waveform settings */
	if (xs_cfg.mos8580) {
  		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cfg_wav_mos8580), TRUE);
  		} else {
  		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cfg_wav_mos6581), TRUE);
  		}
  	

	if (xs_cfg.emulateFilter) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cfg_emufilters), TRUE);
		}

	xs_cfg_filt_update();
	

	/* STIL and miscellaneous settings */
	if (xs_cfg.usestil) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cfg_stil_use), TRUE);
		}

	if (xs_cfg.detectMagic) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cfg_checkfilecontent), TRUE);
		}

	if (xs_cfg.stilpath != NULL) {
		gtk_entry_set_text(GTK_ENTRY(cfg_stil_path), xs_cfg.stilpath);
		}

	if (xs_cfg.fileInfo != NULL) {
		gtk_entry_set_text(GTK_ENTRY(cfg_songnameformat), xs_cfg.fileInfo);
		}

	/* Connect the signals */
	gtk_signal_connect (GTK_OBJECT (cfg_stil_browse), "clicked", GTK_SIGNAL_FUNC (xs_cfg_stil_browse), NULL);

	gtk_signal_connect (GTK_OBJECT (cfg_filt_reset), "clicked", GTK_SIGNAL_FUNC (xs_cfg_filt_reset), NULL);
	
	gtk_signal_connect (GTK_OBJECT (cfg_ok), "clicked", GTK_SIGNAL_FUNC (xs_configure_ok), NULL);
	
	gtk_signal_connect (GTK_OBJECT (cfg_cancel), "clicked", GTK_SIGNAL_FUNC (xs_configure_cancel), NULL);

	gtk_object_set_data (GTK_OBJECT (xs_configwin), "tooltips", tooltips);

	gtk_widget_show(xs_configwin);
}

