package xm::doctype::html;
use xm::o;
use xm::pp;
use xm::sub;
use strict;

sub li_href
{
    my $a = $_[0];
    my $b = $_[0];
    $a =~ s{^\s*(\S+)(.*)$}{\1};
    $b =~ s{^\s*(\S+)\s+(\S+.*)$}{\2};
    return "<li><a href=\"$a\">$b</a></li>";
}
$xm{pp}{call2}{"li-href"}{run} = \&li_href;

sub nobr_href
{
    my $a = $_[0];
    my $b = $_[0];
    $a =~ s{^\s*(\S+)(.*)$}{\1};
    $b =~ s{^\s*(\S+)\s+(\S+.*)$}{\2};
    return "<nobr><a href=\"$a\">$b</a></nobr>";
}
$xm{pp}{call2}{"nobr-href"}{run} = \&nobr_href;

sub meta
{
    my $content = $_[0];
    my $index = index($content,":");
    my ($name);

    if ($index > 0)
    {
        $name = substr($content,0,$index);
	$content =~ s/.*://;
        $name =~ s/^\s*//s; $name =~ s/\s*$//s; 
        $content =~ s/^\s*//s; $content =~ s/\s*$//s; 

	if ($name =~ /^\$/) { $name =~ s:^\$::; $content =~ s:\s*\$$::g ; }
	if ($name =~ /^\%/) { $name =~ s:^\%::; $content =~ s:\s*\%$::g ; }

	if (length $name)
	{
	    $xm{pp}{meta}{$name} = $content;
	
	  xm::pp::pr "debug-meta",$name,"->",$content," ($_[1])";
	
	    return 
		"<meta name=\"".xm::sub::off($name)
		    ."\" content=\"".xm::sub::off($content)."\" />";
	}
    }

    $name = $content; $name =~ s/^\s*//; $name =~ s/\s*$//; 
    my $date = `date`;
    $xm{pp}{meta}{$name} = "";
    
  xm::pp::pr "debug-meta",$name,"\$date ($_[1])";
    return 
	"<meta name=\"".xm::sub::off($name)
	    ."\" date=\"".$date."\" />";
}
$xm{pp}{call2}{"meta"}{run} = \&meta;
$xm{pp}{verb2}{"meta"}{run} = \&meta;

sub put
{
    my $name = $_[0]; $name =~ s{^\s*}{}s; $name =~ s{\s*$}{}s;

    xm::pp::pr "debug-put",$name;

    return $xm{pp}{meta}{$name} if (exists $xm{pp}{meta}{$name});
    return "&lt;".$name."&gt;";
}
$xm{pp}{call2}{"put"}{run} = \&put;
$xm{pp}{tag2}{"put"}{run} = \&put;

1;


