package xm::doctype::guidod;
use xm::o;
use xm::pp;
use strict;

sub splits2_
{
    my ($text,$def,$mark,$attr) = @_;
    xm::pp::pr "debug-split2","splits2_", $mark, join(",",%$def);
    my $sep = $$def{sep};
    my $index = index($text,$sep);

    my $out = $$def{out}; 
    $out =~ s/(>\s*$)/$attr$1/s if not $out =~ s/\$\(\.\)/$attr/s;

    if (length $sep and $index >= 0) #  and $text =~ m/ ^ (.*)$sep(.*) $ /sx)
    {
        return 
            $out
            .$$def{in1}
            .substr($text,0,$index)
            .xm::pp::e($$def{in1})
            .$$def{in2}
            .substr($text,$index + length $sep)
            .xm::pp::e($$def{in2})
            .xm::pp::e($out);
    }
    elsif (not length $sep and $text =~ m/ ^(.*)\s+(.*)/sx)
    {
        return 
            $out
            .$$def{in1}
            .$1
            .xm::pp::e($$def{in1})
            .$$def{in2}
            .$2
            .xm::pp::e($$def{in2})
            .xm::pp::e($$def{out}) ;
    }else{
        return 
            $$def{out}
            .$$def{in1}
            .$text
            .xm::pp::e($$def{in1})
            .$$def{in2}
            .""
            .xm::pp::e($$def{in2})
            .xm::pp::e($out) ;
    }
}

sub use_split2
{
    if ($_[0] =~ /^ \s* <([^<>]+)> \s*
                   ((<[^<>]*>)*) \s* <:> \s*
                   ((<[^<>]*>)*) \s* <:> \s*
                   (([^<>\s]+)|\ ) \s* <:>  \s*
                   ((<[^<>]*>)*) \s* $ /sx)
    {
        my $def = { out => $2, in1 => $4, sep => $6, in2 => $8 };
        $xm{pp}{splits2}{$1}{arg} = $def;
        $xm{pp}{splits2}{$1}{run} = \&splits2_;
        xm::pp::pr "debug-split2","use:split2",$1,"REGISTERED";
        xm::pp::pr "debug-split2","use:split2!", 
		join ("," , keys %{$xm{pp}{splits2}} ),"";
        return "";
    }else{
        return "<!-- use:split2 $_[0] #ignored -->";
    }
}
$xm{pp}{splits2}{"..."} = "...";
$xm{pp}{verb2}{"use:split2"}{run} = \&use_split2;

# ------------------------------------------------------------ #

sub splits3_
{
    my ($text,$def,$mark,$attr) = @_;
    xm::pp::pr "debug-split3","splits3_ ########### ", $mark, join(",",%$def);
    my $sep1 = $$def{sep1};
    my $sep2 = $$def{sep2};
    my $index1 = index($text,$sep1);
    my $index2 = $index1 + length($sep1);
    $index2 = index(substr($text,$index2),$sep2) if length $index1 >= 0;

    my $out = $$def{out}; 
    $out =~ s/(>\s*$)/$attr$1/s if not $out =~ s/\$\(\.\)/$attr/s;

    if (length $sep1 > 0 and $index1 >= 0) 
    {
        return 
            $out
            .$$def{in1}
            .substr($text,0,$index1)
            .xm::pp::e($$def{in1})
            .$$def{in2}
            .substr($text,$index1 + length($sep1), $index2)
            .xm::pp::e($$def{in2})
            .$$def{in3}
            .substr($text,$index1 + length($sep1) + $index2 + length($sep2))
            .xm::pp::e($$def{in3})
            .xm::pp::e($out);
    }
    elsif (not length $sep1 and not length $sep2 and $text =~ m/ ^(.*)\s+(.*)\s+(.*)/sx)
    {
        return 
            $out
            .$$def{in1}
            .$1
            .xm::pp::e($$def{in1})
            .$$def{in2}
            .$2
            .xm::pp::e($$def{in2})
            .$$def{in3}
            .$3
            .xm::pp::e($$def{in3})
            .xm::pp::e($out) ;
    }else{
        return 
            $out
            .$$def{in1}
            .$text
            .xm::pp::e($$def{in1})
            .$$def{in2}
            .""
            .xm::pp::e($$def{in2})
            .$$def{in3}
            .""
            .xm::pp::e($$def{in3})
            .xm::pp::e($out) ;
    }
}

sub use_split3
{
    if ($_[0] =~ /^ \s* <([^<>]+)> \s*
                   ((<[^<>]*>)*) \s* <:> \s*
                   ((<[^<>]*>)*) \s* <:> \s*
                   (([^<>\s]+)|\ ) \s* <:>  \s*
                   ((<[^<>]*>)*) \s* <:> \s*
                   (([^<>\s]+)|\ ) \s* <:>  \s*
                   ((<[^<>]*>)*) \s* $ /sx)
    {
        my $def = { out => $2, 
		in1 => $4, sep1 => $6, 
		in2 => $8, sep2 => $10, in3 => $12 };
        $xm{pp}{splits2}{$1}{arg} = $def;
        $xm{pp}{splits2}{$1}{run} = \&splits3_;
        xm::pp::pr "debug-split3","use:split3",$1,"REGISTERED";
        xm::pp::pr "debug-split3","use:split3!", 
		join ("," , keys %{$xm{pp}{splits2}} ),"";
        return "";
    }else{
        return "<!-- use:split3 $_[0] #ignored -->";
    }
}
$xm{pp}{verb2}{"use:split3"}{run} = \&use_split3;

1;

