package xm::pfe::cutwordsetdocs;
use strict;
use xm::o;
use xm::pfe::cutfcodedocs;

sub DESC
{"
  will look for a <CDOC>/** near the start of the file
  and a wordset-table inside the file. Spit out the combination
  of these two where the CDOC is moved inside the wordset-ITEM.
  if there is a \@description-marker, everything before that is
  discarded.
"}

sub ARGS { return xm::o::args_stdin(@_,DESC); }

sub DO
{
    my $in = shift;
    my $out = "";
    my $comment;
    my $extract;

    # look for a CDOC just near the file-start.
    $in =~ s{ ^(\s*<ITEMXDOC>)*(\s*<CDOC\b[^<>]*>)  
		  ((?:.(?!</?CDOC\b))*.) (</CDOC\b[^<>]*>)
		  }
    { $comment = $2.xm::pfe::cutfcodedocs::format($3).$4 ; "" }sex;

    $extract = "";
    $comment =~ s{ (.*)\@description\b } { $extract = $1; "" }sex;
    if (length $extract)
    {
	$comment .= "<extractInfo>";
	$extract =~ s{ \@author ([^\@\n]*) } 
	{ $comment .= "<authorInfo>".$1."</authorInfo>"; "" }gmex;
	$extract =~ s{ \@version ([^\@\n]*) } 
	{ $comment .= "<versionInfo>".$1."</versionInfo>"; "" }gmex;
	$extract =~ s{ \@see ([^\@\n]*) } 
	{ $comment .= "<seealsoInfo>".$1."</seealsoInfo>"; "" }gmex;
	$comment .= "</extractInfo>";
    }

    $in =~ s{ (<ITEMWORDSET\b[^<>]*>) 
		  ((?:.(?!</?ITEMWORDSET\b))*.) (</ITEMWORDSET\b[^<>]*>)
		  }
    { $out .= $1."<CDOCWORDSET>".$comment."</CDOCWORDSET>\n"
             .$2.$3."\n"; "" }gsex;

    return $out;
}

1;

