package xm::cblocks;
use xm::o;
use strict;

sub DESC 
{" 
  look into the actual C-text and mark pairs of { and }. These are
  then called <CBLK>

  rem: the blocks have depthnumbers.
"}

sub ARGS { return xm::o::args_stdin(@_,DESC); }

sub x_off
{
    my $in = shift;
    
    $in =~ s{\{} {\&\#7B\;}sg;
    $in =~ s{\}} {\&\#7D\;}sg;
    
    return $in;
}

sub x_on
{
    my $in = shift;
    
    $in =~ s{\&\#7B\;} {\{}sg;
    $in =~ s{\&\#7D\;} {\}}sg;
    
    
    return $in
}

sub DO
{
    my $in = shift;
    my $d;
    
    # every brace inside CPRE/CSTR/CCHR/CDOC and their derivatives shall not count
    for $d (qw{ CPRE CSTR CCHR CDOC })
    {
        $in =~ s{<($d[A-Z]*)\b([^<>]*)>(?!<\1\b) 
		   ((?:.(?!</?\1\b))*.) (</\1\b[^<>]*>) } 
            { "<$1$2>".x_off($3).$4 }gsex;
    }
    
    # ready - so let's scan for the brace-pairs...
    
    my $i = 10;
    while ( 
        $in =~ s{ ( \{ [^\{\}]* \} ) }
            { ++$i; "<CBLK $i>".x_off($1)."</CBLK $i>" }gsex
    ) { };
    
    # done. Now move inner CBLKs to CBLKS - makes parsing easier for later modules.
    
    while (
        $in =~ s{ (<CBLK\b\ *\d+>) ((?:.(?!</?CBLK\b\ *\d*>))*.?) 
            		<(CBLK\b\ *\d+)> ((?:.(?!</?CBLK\b \*\d*>))*.?) </\3> }
                { $1.$2."<CBLKS>".$4."</CBLKS>" }gsex
    ) { };
    
    $in =~ s{(</?)CBLK\b\ *\d+>} {$1."CBLK>"}gsex;  # so that blocks are not numbered yet...
    
    # finally revert to braces as literals...
    
    return x_on($in);
} 

1;

