INCLUDE( cmake/FindPkgConfig.cmake )
PKGCONFIG("avahi-client >= 0.6.0")
IF(PKGCONFIG_FOUND)
  IF(CMAKE_PKGCONFIG_C_FLAGS)
    #SET(CMAKE_C_FLAGS "${CMAKE_PKGCONFIG_C_FLAGS} ${CMAKE_C_FLAGS}")
    SET(AVAHI_FOUND TRUE)
    SET(AVAHI_C_FLAGS "${CMAKE_PKGCONFIG_C_FLAGS}")
    SET(AVAHI_LIBS "${PKGCONFIG_LIBRARIES}")
    #do something with ${PKGCONFIG_LIBRARIES}
  ENDIF(CMAKE_PKGCONFIG_C_FLAGS)
ELSE(PKGCONFIG_FOUND)
  MESSAGE(STATUS "Cannot find avahi-client version 0.6.0 or above")
ENDIF(PKGCONFIG_FOUND)

PKGCONFIG("howl >= 1.0.0")
IF(PKGCONFIG_FOUND)
  IF(CMAKE_PKGCONFIG_C_FLAGS)
    #SET(CMAKE_C_FLAGS "${CMAKE_PKGCONFIG_C_FLAGS} ${CMAKE_C_FLAGS}")
    SET(HOWL_FOUND TRUE)
    SET(HOWL_C_FLAGS "${CMAKE_PKGCONFIG_C_FLAGS}")
    SET(HOWL_LIBS "${PKGCONFIG_LIBRARIES}")
    #do something with ${PKGCONFIG_LIBRARIES}
  ENDIF(CMAKE_PKGCONFIG_C_FLAGS)
ELSE(PKGCONFIG_FOUND)
  MESSAGE(STATUS "Cannot find howl version 0.6.0 or above")
ENDIF(PKGCONFIG_FOUND)

IF(AVAHI_FOUND)
  SET(ZEROCONF_FOUND TRUE)
  SET(ZEROCONF_IMPLEMENTATION "avahi")

  # check whether Avahi supports AvahiThreadedPoll
  EXEC_PROGRAM(${CMAKE_PKGCONFIG_EXECUTABLE}
      ARGS "--atleast-version=0.6.4 'avahi-client'"
      OUTPUT_VARIABLE VAR_AVAHI_CHECK_VERSION
      RETURN_VALUE RETURN_CHECK_AVAHI_VERSION)
  IF (NOT RETURN_CHECK_AVAHI_VERSION)
    SET(AVAHI_SUPPORT_THREADEDPOLL TRUE)
  ENDIF (NOT RETURN_CHECK_AVAHI_VERSION)
ENDIF(AVAHI_FOUND)

IF(HOWL_FOUND)
  IF (AVAHI_FOUND)
    MESSAGE(STATUS "Both avahi and howl were found. Choosing avahi by default")
  ELSE (AVAHI_FOUND)
    SET(ZEROCONF_FOUND TRUE)
    SET(ZEROCONF_IMPLEMENTATION "howl")
  ENDIF (AVAHI_FOUND)
ENDIF(HOWL_FOUND)
