class node_stmt;
typedef char Bool;

//-----------------------------------------------------------------------------
// Define types for nodes in parse tree.
// The *expr types are expressions (rvalues) and the *var types variabels (lvalues)

class node_stmt {
  public:
  virtual void eval()=0;
};

class node_int64expr {
  public:
  virtual int64 eval()=0;
};

class node_boolexpr {
  public:
  virtual Bool eval()=0;
};

class node_macexpr {
  public:
  virtual mac_addr eval()=0;
};

class node_ipexpr {
  public:
  virtual ip_addr eval()=0;
};

class node_int64var {
  public:
  virtual int64* eval()=0;
};

class node_boolvar {
  public:
  virtual Bool* eval()=0;
};

class node_macvar {
  public:
  virtual mac_addr* eval()=0;
};

class node_ipvar {
  public:
  virtual ip_addr* eval()=0;
};

class node_idexpr {
  public:
  virtual card_id eval()=0;
};

//-----------------------------------------------------------------------------

// A constant expression of type T:
template<class BaseT, class T> class Constant:public BaseT {
  T A;
  virtual T eval() { return A; }
  public:
  Constant(T value) : A(value) {}
};
typedef Constant<node_int64expr,int64> ConstInt64;
typedef Constant<node_boolexpr,Bool> ConstBool;
typedef Constant<node_macexpr,mac_addr> ConstMac;
typedef Constant<node_ipexpr,ip_addr> ConstIp;

// A variabel with a user suplied location:
template<class BaseT, class T> class Variabel:public BaseT {
  T* A;
  virtual T* eval() { return A; }
  public:
  Variabel(T* location) : A(location) {}
};
typedef Variabel<node_int64var,int64> VariabelInt64;
typedef Variabel<node_boolvar,Bool> VariabelBool;
typedef Variabel<node_macvar,mac_addr> VariabelMac;
typedef Variabel<node_ipvar,ip_addr> VariabelIp;

// A vaiabel including storage and with a user suplied initaial value:
template<class BaseT, class T> class DynVar:public BaseT {
  T A;
  virtual T* eval() { return &A; }
  public:
  DynVar(T initialvalue) : A(initialvalue) {}
};
typedef DynVar<node_int64var,int64> DynVarInt64;
typedef DynVar<node_boolvar,Bool> DynVarBool;
typedef DynVar<node_macvar,mac_addr> DynVarMac;
typedef DynVar<node_ipvar,ip_addr> DynVarIp;

// An int64 expression that the user has in an int at a given location.
class IntToInt64Expr:public node_int64expr {
  int* a;
  virtual int64 eval() { return *a; }
    
  public:
  IntToInt64Expr(int* A) : a(A) {}
};

//-----------------------------------------------------------------------------
// The symbol table

const int maxsymbols=40;
const int maxsymlen=20;

class Symtable {    
  public:
  Symtable() {  clear(); }  
  void clear() { symc=0; }
  
  union valueu {
    node_int64var* int64_value;
    node_boolvar*  bool_value;
    node_macvar*   mac_value;
    node_ipvar*    ip_value;
  };
  
  struct SymEntry {
    char   name[maxsymlen+1]; // Name of variabel
    int    valid;             // True if the variabel is valid.
    ParseProgram::types type; // Type of variabel
    valueu value;             // Location of variabel
  };
  
  // Returns the given symbol if it exists and 0 if it doesn't
  SymEntry* getSymbol(char* name);
  
  // Creates a new symbol of the given type. setSymbol must be called
  // afterwards to make the symbol valid. Returns 0 on error and calls
  // yyerror.
  SymEntry* createSymbol(char* name);
  
  // Sets the type and location af a symbol made with createSymbol.
  // The function also allocates a memory location for the symbol and
  // sets its contest to 0.
  void setType(SymEntry* se, ParseProgram::types type);

  private:
  
  SymEntry symbols[maxsymbols]; // Symbol tabel
  int symc;                     // Number of symbols in table  
};

extern Symtable symtabel;

