/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

public class Configuration {
    private String _name;
    private String _description;
    private String[] _extends;
    private Visibility _visibility;

    public Configuration(String name, Visibility visibility, String description, String[] ext) {
        if (name == null) {
            throw new NullPointerException("null configuration name not allowed");
        }
        if (visibility == null) {
            throw new NullPointerException("null visibility not allowed");
        }
        this._name = name;
        this._visibility = visibility;
        this._description = description;
        if (ext == null) {
            this._extends = new String[0];
        } else {
            this._extends = new String[ext.length];
            for (int i = 0; i < ext.length; ++i) {
                this._extends[i] = ext[i].trim();
            }
        }
    }

    public Configuration(String name) {
        this(name, Visibility.PUBLIC, null, null);
    }

    public String getDescription() {
        return this._description;
    }

    public String[] getExtends() {
        return this._extends;
    }

    public String getName() {
        return this._name;
    }

    public Visibility getVisibility() {
        return this._visibility;
    }

    public String toString() {
        return this._name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Configuration)) {
            return false;
        }
        return ((Configuration)obj).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public static class Visibility {
        public static Visibility PUBLIC = new Visibility("public");
        public static Visibility PRIVATE = new Visibility("private");
        private String _name;

        public static Visibility getVisibility(String name) {
            if ("private".equals(name)) {
                return PRIVATE;
            }
            if ("public".equals(name)) {
                return PUBLIC;
            }
            throw new IllegalArgumentException("unknwon visibility " + name);
        }

        private Visibility(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }
}

