/*
 * ===========================
 * VDK Visual Development Kit
 * xdb subsystem
 * Version 0.1
 * Revision 0.0
 * April 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <vdkxdb2/vdkxentry.h>
#include <vdkxdb2/vdkxdb.h>
#include <vdk/vdkdate.h>


void
VDKXEntry::RealizeSignal (GtkWidget* wid,  gpointer gp )
{
  VDKXEntry* entry = reinterpret_cast <VDKXEntry*>(gp);
  if(entry)
    {
    GtkStyle *style = 
        gtk_widget_get_style(GTK_WIDGET(entry->Widget())); 
        entry->default_color = 
                gdk_color_copy(&(style->base[GTK_STATE_NORMAL]));
    }
}


int
VDKXEntry::FocusOut(GtkWidget *,
			    GdkEventFocus*,
			    gpointer wid)
{
  VDKXEntry* entry = reinterpret_cast<VDKXEntry*>(wid);
  if(entry && entry->default_color && entry->FocusColor)
    {
    		gtk_widget_modify_base (entry->Widget(), 
                  GTK_STATE_NORMAL,entry->default_color);
    }
  return FALSE;
}

int
VDKXEntry::FocusIn(GtkWidget *,
			    GdkEventFocus*,
			    gpointer wid)
{
  VDKXEntry* entry = reinterpret_cast<VDKXEntry*>(wid);
  if(entry && entry->FocusColor)
    {
        VDKColor* color = entry->FocusColor;
		 gtk_widget_modify_base (entry->Widget(), GTK_STATE_NORMAL, 
         color->Color());
    }
 
  return FALSE;
}


VDKXEntry::VDKXEntry(VDKForm* owner, int maxLen , char* def): 
  VDKEntry(owner,maxLen,def), VDKXControl(),
  FocusColor("FocusColor", this,NULL),
  DateMode("DateMode",this,mmddyyyy)

{
  default_color = NULL;
  g_signal_connect_data (widget, "realize", 
      G_CALLBACK (VDKXEntry::RealizeSignal), (gpointer) this, 
      NULL,(GConnectFlags) 0);
      
  gtk_signal_connect(GTK_OBJECT(widget),
		       "focus_out_event",
		       GTK_SIGNAL_FUNC(VDKXEntry::FocusOut),
		       (gpointer) this);
/*		       
  gtk_signal_connect(GTK_OBJECT(widget),
		       "focus_in_event",
		       GTK_SIGNAL_FUNC(VDKXEntry::FocusIn),
		       (gpointer) this);		       
*/
  g_signal_connect_data (widget, "focus_in_event", 
      G_CALLBACK (VDKXEntry::FocusIn), this, 
      NULL,(GConnectFlags) 0);      
/*      
  g_signal_connect_data (sigwid, "focus_out_event", 
      G_CALLBACK (VDKXEntry::FocusOut), this, 
      NULL,(GConnectFlags) 0);            
*/      
}


VDKXEntry::~VDKXEntry()
{

}

bool 
VDKXEntry::AssignTableField(VDKXTable* t,
			    char* fname)
{
  if(t)
    {
      xbShort id = t->GetFieldNo(fname);
      xbShort type = t->GetFieldType(id);
      if((type != 'M') && (type != 'L') )
	return VDKXControl::AssignTableField(t, fname);
      else
	return false;
    }
  else
    return false;
}
/*
 */
xbShort
VDKXEntry::Read()
{
  int mode = DateMode;
  xbShort l, rc = XB_NOT_OPEN; 
  char* buffer = NULL;
  if(table)
    {
      calendardate d;
      l = table->GetFieldLen(field_id);
      buffer = new char[l+1];
      rc = table->GetField(field_id,buffer);
      if(rc)
	{
	  switch(field_type)
	    {
	    case 'D':
	      d = MakeDate(buffer,mode);
	      Text = (char*) d;
	      break;

	    case 'N':
	    case 'F':
	      Text = table->xbase->LTRIM(buffer);
	      break;

	    default:
	      Text = table->xbase->RTRIM(buffer);
	      break;
	      
	    }
	}
      if(buffer)
	delete[] buffer;
    }
  return XB_NO_ERROR;
}
/*
 */
xbShort
VDKXEntry::Write()
{
  calendardate d;
  int mode = DateMode;
  xbShort rc = XB_NOT_OPEN, l;
  char* buffer = NULL;
  if(table)
    {
      l = table->GetFieldLen(field_id);
      switch(field_type)
	{
	case 'D':
	  d = calendardate(Text,mode);
	  if (d.Valid())
	    rc = table->PutField(field_id,d.AsString());
	  break;

	case 'N':
	case 'F':
	  buffer = new char[l+1];
	  strcpy(buffer,(char*) Text);
	  rc = table->PutField(field_id,table->xbase->LTRIM(buffer));
	  break;

	default:
	  rc = table->PutField(field_id,(char*) Text);
	}
      if(buffer)
	delete[] buffer;
    }
  return rc;
}


