# $Id: time.tcl,v 1.5 2006/06/12 20:38:16 aleksey Exp $

custom::defvar options(reply_iq_time) 1 \
    [::msgcat::mc "Reply to current time (jabber:iq:time) requests."] \
    -group IQ -type boolean

proc iq_time {connid from child} {
    variable options

    if {!$options(reply_iq_time)} {
	return {error cancel service-unavailable}
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    set curtime [clock seconds]
    set restags \
	[list [jlib::wrapper:createtag utc \
		   -chdata [clock format $curtime \
				-format "%Y%m%dT%T" -gmt true]] \
	     [jlib::wrapper:createtag tz -chdata \
		  [timezone $curtime]] \
	     [jlib::wrapper:createtag display \
		  -chdata [displaytime $curtime]]]
    
    set res [jlib::wrapper:createtag query \
		 -vars {xmlns jabber:iq:time} \
		 -subtags $restags]
    
    return [list result $res]
}

proc timezone {time} {
    global tcl_platform

    if {[cequal $tcl_platform(platform) "windows"] && \
	    [package vcompare [info patchlevel] 8.4.12] < 0} {
	return [string trim [encoding convertfrom utf-8 \
		[encoding convertto [clock format $time -format "%Z%t"]]]]
    } else {
	return [clock format $time -format %Z]
    }
}

proc displaytime {time} {
    global tcl_platform

    if {[cequal $tcl_platform(platform) "windows"] && \
	    [package vcompare [info patchlevel] 8.4.12] < 0} {
	return [encoding convertfrom utf-8 \
		[encoding convertto [clock format $time]]]
    } else {
	return [clock format $time]
    }
}

iq::register_handler get query jabber:iq:time \
    [namespace current]::iq_time

