#ifndef GIF_LIB_PRIVATE_H
#define GIF_LIB_PRIVATE_H

#include <sioGeneral.h>
#include "bm_gif_lib.h"

#define FILE_STATE_WRITE    0x01
#define FILE_STATE_SCREEN   0x02
#define FILE_STATE_IMAGE    0x04
#define FILE_STATE_READ     0x08

#define IS_READABLE(Private)    (Private->FileState & FILE_STATE_READ)
#define IS_WRITEABLE(Private)   (Private->FileState & FILE_STATE_WRITE)

typedef struct GifFilePrivateType {
    int				FileState;
    unsigned long		PixelCount;
				    /* Number of pixels in image.	*/
				    /* Actually those not read/written.	*/

    SimpleOutputStream *	gfptSos;
    SimpleOutputStream *	gfptSosBlocked;
    SimpleOutputStream *	gfptSosLzw;

    SimpleInputStream *		gfptSis;
    SimpleInputStream *		gfptSisBlocked;
    SimpleInputStream *		gfptSisLzw;
} GifFilePrivateType;

extern int _GifError;

#endif /* GIF_LIB_PRIVATE_H */
