#####################################################################
##
##   Look for libxpm
##
#####################################################################

AC_DEFUN(AC_PATH_XPM,
[
    echo Checking for libxpm...

    XPM_CFLAGS=
    XPM_LIBS=
    HAVE_XPM=NO_XPM

    ac_xpm_includes=NO
    ac_xpm_libraries=NO

    # Includes
    for ac_dir in			\
	/usr/X11R6/include		\
	/usr/local/include		\
	/usr/pkg/include		\
	/usr/local/include/X11R6	\
	/usr/apps/include		\
	../xpm
    do
    if  test -r "$ac_dir/X11/xpm.h"
	then
	    ac_xpm_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in			\
	/usr/X11R6/lib			\
	/usr/local/lib			\
	/usr/pkg/lib			\
	/usr/local/lib/X11R6		\
	/usr/apps/lib			\
	../xpm/lib
    do
    if  test -r "$ac_dir/libXpm.a"
	then
	    ac_xpm_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_xpm_includes
    #echo Libraries: $ac_xpm_libraries

    if  test $ac_xpm_includes != NO
    then
	XPM_CFLAGS=-I$ac_xpm_includes
	HAVE_XPM=HAVE_XPM

	if  test "$XPM_CFLAGS" = "$X_CFLAGS"
	then
	    XPM_CFLAGS=
	fi
    fi

    if  test $ac_xpm_libraries != NO
    then
	XPM_LIBS="-L$ac_xpm_libraries"

	if  test "$XPM_LIBS" = "$X_LIBS"
	then
	    XPM_LIBS=
	fi
    fi

    AC_SUBST(XPM_CFLAGS)dnl
    AC_SUBST(XPM_LIBS)dnl
    AC_SUBST(HAVE_XPM)dnl
])
#####################################################################
##
##   Look for libpng
##
#####################################################################

AC_DEFUN(AC_PATH_PNG,
[
    echo Checking for libpng...

    PNG_CFLAGS=
    PNG_LIBS=

    ac_png_includes=NO
    ac_png_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/local/include	\
	/usr/pkg/include	\
	/usr/X11R6/include	\
	/usr/local/include/png	\
	/usr/apps/include	\
	../libpng
    do
    if  test -r "$ac_dir/png.h"
	then
	    ac_png_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/local/lib		\
	/usr/pkg/lib		\
	/usr/apps/lib		\
	/usr/local/lib/png	\
	/usr/X11R6/lib		\
	../libpng
    do
    if  test -r "$ac_dir/libpng.a"
	then
	    ac_png_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_png_includes
    #echo Libraries: $ac_png_libraries

    if  test $ac_png_includes != NO
    then
	PNG_CFLAGS=-I$ac_png_includes
    fi

    if  test $ac_png_libraries != NO
    then
	PNG_LIBS="-L$ac_png_libraries"
    fi

    AC_SUBST(PNG_CFLAGS)dnl
    AC_SUBST(PNG_LIBS)dnl
])
#####################################################################
##
##   Look for zlib
##
#####################################################################

AC_DEFUN(AC_PATH_ZLIB,
[
    echo Checking for zlib...

    ZLIB_CFLAGS=
    ZLIB_LIBS=

    ac_zlib_includes=NO
    ac_zlib_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/include		\
	/usr/local/include	\
	/usr/pkg/include	\
	/usr/local/include/zlib	\
	/usr/apps/include	\
	../zlib
    do
    if  test -r "$ac_dir/zlib.h"
	then
	    ac_zlib_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/lib		\
	/usr/local/lib		\
	/usr/pkg/lib		\
	/usr/local/lib/zlib	\
	/usr/apps/lib		\
	../zlib
    do
    if  test -r "$ac_dir/libz.a"
	then
	    ac_zlib_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_zlib_includes
    #echo Libraries: $ac_zlib_libraries

    if  test $ac_zlib_includes != NO
    then
	ZLIB_CFLAGS=-I$ac_zlib_includes
    fi

    if  test $ac_zlib_libraries != NO
    then
	ZLIB_LIBS="-L$ac_zlib_libraries"
    fi

    AC_SUBST(ZLIB_CFLAGS)dnl
    AC_SUBST(ZLIB_LIBS)dnl
])
#####################################################################
##
##   Look for libjpeg
##
#####################################################################

AC_DEFUN(AC_PATH_JPEG,
[
    echo Checking for libjpeg...

    JPEG_CFLAGS=
    JPEG_LIBS=
    HAVE_JPEG=NO_JPEG

    ac_jpeg_includes=NO
    ac_jpeg_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/local/include	\
	/usr/include		\
	/usr/pkg/include	\
	/usr/local/include/jpeg	\
	/usr/apps/include	\
	../jpeg
    do
    if  test -r "$ac_dir/jpeglib.h"
	then
	    ac_jpeg_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/local/lib		\
	/usr/lib		\
	/usr/pkg/lib		\
	/usr/local/lib/jpeg	\
	/usr/apps/lib		\
	../jpeg
    do
    if  test -r "$ac_dir/libjpeg.a"
	then
	    ac_jpeg_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_jpeg_includes
    #echo Libraries: $ac_jpeg_libraries

    if  test $ac_jpeg_includes != NO
    then
	HAVE_JPEG=HAVE_JPEG
	JPEG_CFLAGS=-I$ac_jpeg_includes
    fi

    if  test $ac_jpeg_libraries != NO
    then
	JPEG_LIBS="-L$ac_jpeg_libraries"
    fi

    AC_SUBST(JPEG_CFLAGS)dnl
    AC_SUBST(JPEG_LIBS)dnl
    AC_SUBST(HAVE_JPEG)dnl
])
#####################################################################
##
##   Look for libtiff
##
#####################################################################

AC_DEFUN(AC_PATH_TIFF,
[
    echo Checking for libtiff...

    TIFF_CFLAGS=
    TIFF_LIBS=

    ac_tiff_includes=NO
    ac_tiff_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/local/include	\
	/usr/pkg/include	\
	/usr/local/include/tiff	\
	/usr/apps/include	\
	../tiff/libtiff
    do
    if  test -r "$ac_dir/tiffio.h"
	then
	    ac_tiff_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/local/lib		\
	/usr/pkg/lib		\
	/usr/local/lib/tiff	\
	/usr/apps/lib		\
	../tiff/libtiff
    do
    if  test -r "$ac_dir/libtiff.a"
	then
	    ac_tiff_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_tiff_includes
    #echo Libraries: $ac_tiff_libraries

    if  test $ac_tiff_includes != NO
    then
	TIFF_CFLAGS=-I$ac_tiff_includes
    fi

    if  test $ac_tiff_libraries != NO
    then
	TIFF_LIBS="-L$ac_tiff_libraries"
    fi

    AC_SUBST(TIFF_CFLAGS)dnl
    AC_SUBST(TIFF_LIBS)dnl
])
