/************************************************************************/
/*									*/
/*  Exchange text properties with an RTF file.				*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	"docRtf.h"

/************************************************************************/
/*									*/
/*  Save a text attribute (change).					*/
/*									*/
/************************************************************************/

void docRtfSaveTextAttribute(		SimpleOutputStream *	sos,
					int *			pCol,
					const PropertyMask *	updMask,
					const TextAttribute *	ta )
    {
    if  ( PROPmaskISSET( updMask, TApropFONTFAMILY ) )
	{ docRtfWriteArgTag( "\\f", pCol, ta->taFontNumber, sos ); }

    if  ( PROPmaskISSET( updMask, TApropFONTSIZE ) )
	{ docRtfWriteArgTag( "\\fs", pCol, ta->taFontSizeHalfPoints, sos ); }

    if  ( PROPmaskISSET( updMask, TApropFONTBOLD ) )
	{
	if  ( ta->taFontIsBold )
	    { docRtfWriteTag( "\\b", pCol, sos );			}
	else{ docRtfWriteArgTag( "\\b", pCol, ta->taFontIsBold, sos );	}
	}

    if  ( PROPmaskISSET( updMask, TApropFONTSLANTED ) )
	{
	if  ( ta->taFontIsSlanted )
	    { docRtfWriteTag( "\\i", pCol, sos );			}
	else{ docRtfWriteArgTag( "\\i", pCol, ta->taFontIsSlanted, sos ); }
	}

    if  ( PROPmaskISSET( updMask, TApropTEXTUNDERLINED ) )
	{
	if  ( ta->taIsUnderlined )
	    { docRtfWriteTag( "\\ul", pCol, sos );			 }
	else{ docRtfWriteArgTag( "\\ul", pCol, ta->taIsUnderlined, sos ); }
	}

    if  ( PROPmaskISSET( updMask, TApropSUPERSUB ) )
	{
	switch( ta->taSuperSub )
	    {
	    case DOCfontREGULAR:
		docRtfWriteTag( "\\nosupersub", pCol, sos );
		break;

	    case DOCfontSUPERSCRIPT:
		docRtfWriteTag( "\\super", pCol, sos );
		break;

	    case DOCfontSUBSCRIPT:
		docRtfWriteTag( "\\sub", pCol, sos );
		break;

	    default:
		LDEB(ta->taSuperSub);
	    }
	}

    if  ( PROPmaskISSET( updMask, TApropSMALLCAPS ) )
	{
	if  ( ta->taSmallCaps )
	    { docRtfWriteTag( "\\scaps", pCol, sos );			 }
	else{ docRtfWriteArgTag( "\\scaps", pCol, ta->taSmallCaps, sos ); }
	}

    if  ( PROPmaskISSET( updMask, TApropCAPITALS ) )
	{
	if  ( ta->taCapitals )
	    { docRtfWriteTag( "\\caps", pCol, sos );			}
	else{ docRtfWriteArgTag( "\\caps", pCol, ta->taCapitals, sos );	}
	}

    if  ( PROPmaskISSET( updMask, TApropSTRIKETHROUGH ) )
	{
	if  ( ta->taHasStrikeThrough )
	    { docRtfWriteTag( "\\strike", pCol, sos );			}
	else{
	    docRtfWriteArgTag( "\\strike", pCol, ta->taHasStrikeThrough, sos );
	    }
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Handle a text property when reading RTF.				*/
/*									*/
/************************************************************************/

int docRtfRememberTextProperty(		SimpleInputStream *	sis,
					const RtfControlWord *	rcw,
					int			arg,
					RtfReadingContext *	rrc )
    {
    switch( rcw->rcwId )
	{
	case TAprop_NONE:
	    docInitTextAttribute( &(rrc->rrcCurrentTextAttribute) );
	    if  ( rrc->rrcBd )
		{
		rrc->rrcCurrentTextAttribute.taFontNumber=
				    rrc->rrcBd->bdProperties.dpDefaultFont;
		}
	    rrc->rrcCurrentTextAttribute.taFontSizeHalfPoints= 24;
	    rrc->rrcInDeletedText= 0;
	    return 0;

	case TApropFONTFAMILY:
	    rrc->rrcCurrentTextAttribute.taFontNumber= arg;
	    break;

	case TApropFONTSIZE:
	    rrc->rrcCurrentTextAttribute.taFontSizeHalfPoints= arg;
	    break;

	case TApropFONTBOLD:
	    rrc->rrcCurrentTextAttribute.taFontIsBold= arg != 0;
	    break;

	case TApropFONTSLANTED:
	    rrc->rrcCurrentTextAttribute.taFontIsSlanted= arg != 0;
	    break;

	case TApropTEXTUNDERLINED:
	    rrc->rrcCurrentTextAttribute.taIsUnderlined= arg != 0;
	    break;

	case TApropSHOWASLINK:
	    SDEB(rcw->rcwWord);
	    return 0;

	case TApropSUPERSUB:
	    rrc->rrcCurrentTextAttribute.taSuperSub= rcw->rcwEnumValue;
	    break;

	case TApropSMALLCAPS:
	    rrc->rrcCurrentTextAttribute.taSmallCaps= arg != 0;
	    break;

	case TApropCAPITALS:
	    rrc->rrcCurrentTextAttribute.taCapitals= arg != 0;
	    break;

	case TApropSTRIKETHROUGH:
	    rrc->rrcCurrentTextAttribute.taHasStrikeThrough= arg != 0;
	    break;

	default:
	    SDEB(rcw->rcwWord);
	    return 0;
	}

    PROPmaskADD( &(rrc->rrcStyle.dsTextMask), rcw->rcwId );

    return 0;
    }
